#ifndef UBL_UTILS_UI
#define UBL_UTILS_UI
#include <gtk/gtk.h>
#include <gtk/gtkx.h>
#include <libublsettings.h>
#include <libublsettings-gtk3.h>
#include <vte/vte.h>
#include <locale.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <libintl.h>
#include <getopt.h>
#ifdef WEBKIT_INCLUDE
    #include <webkit2/webkit2.h>
#endif
#define ui_WIKI_LINK "https://wiki.ublinux.ru/ru/Программное_обеспечение/Программы_и_утилиты/Все/ublsettingsui-gtk3"

#define _(String) gettext(String)

/**Префикс для всех икнок из библиотеки.*/
#define yon_dull_icon_path "com.ublinux.libublsettingsui-gtk3"

/**Путь до файла основного окна утилит ubl-settings-**/
#define ui_glade_path "/com/ublinux/ui/libublsettingsui-gtk3.glade"

/**Путь до файла подтверждения открытия документации утилит ubl-settings-**/
#define ui_glade_path_documentation "/com/ublinux/ui/libublsettingsui-gtk3-documentation.glade"

/**Путь до файла окна "О программе" утилит ubl-settings-**/
#define ui_glade_path_about "/com/ublinux/ui/libublsettingsui-gtk3-about.glade"

/**Путь до файла окна сохранения утилит ubl-settings-**/
#define ui_glade_path_saving "/com/ublinux/ui/libublsettingsui-gtk3-saving.glade"

/**Путь до файла окна выбора файлов утилит ubl-settings-**/
#define ui_glade_path_filechooser "/com/ublinux/ui/libublsettingsui-gtk3-filechooser.glade"

/**Путь до файла окна отладки утилит ubl-settings-**/
#define ui_glade_path_debug "/com/ublinux/ui/libublsettingsui-gtk3-debugger.glade"

/**Путь до файла окна управления юнитами утилит ubl-settings-**/
#define ui_glade_path_service "/com/ublinux/ui/libublsettingsui-gtk3-service-control.glade"

/**Путь до файла окна выбора приложений утилит ubl-settings-**/
#define ui_glade_path_app_chooser "/com/ublinux/ui/libublsettingsui-gtk3-app-chooser.glade"

/**Путь до файла окна ввода пароля */
#define ui_glade_path_password "/com/ublinux/ui/libublsettingsui-gtk3-password.glade"

/**Путь до основного баннера утилит ubl-settings-**/
#define ui_banner_path "/com/ublinux/images/libublsettingsui-gtk3-banner.png"

/**Путь до файла стилей для утилит*/
#define ui_CssPath "/com/ublinux/css/libublsettingsui-gtk3.css"

/**Путь до файла конфигурации утилит*/
#define ui_config_path yon_char_unite(yon_ubl_user_get_home_directory(),"/.config/",template_app_information.app_tech_name,"/",template_app_information.app_tech_name,".conf",NULL)

/**Команда удаления файла конфигурации утилит*/
#define remove_config_dir_command yon_char_unite("rm -rfd ", yon_ubl_user_get_home_directory(),"/.config/",template_app_information.app_tech_name,"/",NULL)

/**Шаблон команды сохраненния/удаления/получения параметров из конфигурации*/
#define dull_parameter_get_command "ubconfig --source global get users PARAMETER"

/**Команда получения режима загрузки*/
#define SAVE_MODE_GET_COMMAND "ubconfig --raw --source system get [config] SYSTEMBOOT_STATEMODE"

/**Команда создания файла конфигурации ubconfig
 * @target - путь до создаваемого файла
*/
#define ubconfig_file_create(target) yon_char_unite("ubconfig --target \"",target,"\" create",NULL)

/**Типы */
typedef enum SAVE_MODE_TYPE {
    SAVE_MODE_FULL,
    SAVE_MODE_MODULE,
    SAVE_MODE_SANDBOX,
    SAVE_MODE_RAM_HOME,
    SAVE_MODE_HDD,
    SAVE_MODE_HDD_HOME,
} SAVE_MODE_TYPE;

/**Получить локализованную строку из библиотеки
*/
char *yon_char_get_localised_from_lib(char *string);

/**Получить название иконки для режима сохранения
*/
char *yon_ubl_save_mode_get_icon_name(SAVE_MODE_TYPE type);

/**Конввертировать вывод команды SAVE_MODE_GET_COMMAND в SAVE_MODE_TYPE*/
SAVE_MODE_TYPE yon_ubl_save_mode_get_type(char *type);

/**Структура с информацией об утилите, использующей библиотеку.
 * @interface - виджет, корень интерфейса запущенной утилиты. Добавляется в окно из библиотеки
 * @app_locale - имя файла локализации откуда будет загружаться локализация утилиты
 * @css_path - путь до файла css стилей утилиты
 * @app_title - Название утилиты для отображения на баннере и на окнах из библиотеки
 * @app_description - описание утилиты для отображения на баннере.
 * @app_texh_name - техническое название утилиты (ubl-settings-*)
 * @app_version - текстовая строка с версией утилиты
 * @wiki_link - ссылка на страницу wiki утилиты
*/
typedef struct {
    GtkWidget *interface;

    char *app_locale;
    char *css_path;
    
    char *app_title;
    char *app_description;

    char *app_tech_name;
    char *app_version;
    char *wiki_link;
    
    gboolean always_open_documentation;
} template_app_info;

extern template_app_info template_app_information;

/**Стандартные поля для конфигурации утилиты.
 * template_config_fields ДОЛЖЕН РАСПОЛАГАТЬСЯ ПЕРВЫМ В СТРУКТУРЕ КОНФИГУРАЦИИ*/
#define template_config_fields\
    int socket_id;\
    int load_socket_id;\
    int save_socket_id;\
    \
    int lock_help;\
    int lock_save_local;\
    int lock_save_global;\
    int lock_load_global;\
    int lock_load_system;\
\
    int load_mode;\
\
    int always_open_documentation;\
    int debug_mode;\
    char *custom_load_path;

typedef struct {
    template_config_fields
} _template_config;

/**Указатель на конфиг. В него попадает указатель на основной конфиг утилиты с полями @template_fields*/
extern _template_config *template_config;

[[maybe_unused]]
extern _template_config *template_config;

/**Поля структуры основного окна утилиты, настраивыемые через бибилотеку. template_window_fields ДОЛЖЕН РАСПОЛАГАТЬСЯ ПЕРВЫМ В СТРУКТУРЕ*/
#define template_window_fields\
    GtkWidget *Window;\
    GtkWidget *HeadLabel;\
    GtkWidget *PlugBox;\
\
    GtkWidget *HeadOverlay;\
    GtkWidget *HeadImage;\
    GtkWidget *HeadBox;\
    GtkWidget *HeadTitleLabel;\
    GtkWidget *HeadInfoLabel;\
\
    GtkWidget *StatusBox;\
    GtkWidget *StatusIcon;\
    GtkWidget *StatusLabel;\
\
    GtkWidget *SaveMenuItem;\
    GtkWidget *SaveGlobalMenuItem;\
    GtkWidget *SaveLocalMenuItem;\
    GtkWidget *SaveCustomMenuItem;\
    GtkWidget *RightBox;\
\
    GtkWidget *LoadGlobalMenuItem;\
    GtkWidget *LoadLocalMenuItem;\
    GtkWidget *LoadCustomMenuItem;\
    GtkWidget *LeftBox;\
\
    GtkWidget *DocumentationMenuItem;\
    GtkWidget *AboutMenuItem;\
\
    GtkWidget *InterfaceBox;\
    //}

/**Структура с основным окном утилиты*/
typedef struct {
    template_window_fields
} template_main_window;

/**Структура с окном подтверждения перехода к документации*/
typedef struct {
    GtkWidget *Window;
    GtkWidget *HeaderLabel;

    GtkWidget *AlwaysOpenCheck;

    GtkWidget *CloseButton;
    GtkWidget *AcceptButton;
} template_documentation_confirmation_window;

/**Структура с окном режима отладки*/
typedef struct {
    GtkWidget *Window;
    GtkWidget *HeaderTopic;
    GtkWidget *HeaderImage;
    GtkWidget *StatusBox;
    GtkWidget *Vte;
} template_debug_window;

/**Структура для диалогового окна подтверждения.
 * @void (*function)(void*,void*) - указатель на функцию выполняюзуюся в случае нажатия на кнопку "Принять". Первый параметр - Указатель на окно или виджета, расположенного в этом окне
 * @data - параметр, передающийся в функцию
 * @action_text - отображаемый в диалоговом окне текст действия, требующего подтверждения
 * @title - текст в шапке диалогового окна
*/
typedef struct {
    void (*function)(void*,void*);
    void *data;
    char *action_text;
    char *title;
} dialog_confirmation_data;

/**Структура для окна выбора файлов.
 * @Window - виджет окна
 * @StatusBox - виджет для показа статусных сообщений, пустой GtkBox с вертикальной ориентацией
 * @HeaderTopic - виджет текста в шапке окна 
 * @MainFileChooser - виджет выбора файлов.
 * @SaveButton - Кнопка принятия выбора. Закрывает окно и устанавливает responce равным GTK_RESPONCE_ACCEPT если был выбран файл
 * @CancelButton - кнопка отмены. Закрывает окно и 
*/
typedef struct {
    GtkWidget *Window;
    GtkWidget *StatusBox;
    GtkWidget *HeaderTopic;
    GtkWidget *MainFileChooser;
    GtkWidget *SaveButton;
    GtkWidget *CancelButton;
    GtkWidget *ChooseFolderCheck;
    char *last_success_selection;
    char *last_any_selection;
    GtkResponseType responce;
    char *root;
} filechooser_window;

filechooser_window *yon_file_chooser_window_new(GtkFileChooserAction action);
GtkResponseType yon_file_chooser_start(filechooser_window *window);
void yon_file_chooser_set_button_label(char *label);
void yon_file_chooser_set_root(filechooser_window *window, char *root_path);
void yon_file_chooser_remove_root(filechooser_window *window, char *root_path);


dialog_confirmation_data *yon_confirmation_dialog_data_new();

int yon_confirmation_dialog_call(GtkWidget *self,dialog_confirmation_data *data);

/**yon_open_browser(GtkWidget *self, char *link)
 * [EN]
 * Opens browser with [link] link.
 * [RU]
 * Открывает браузер с [link] ссылкой.
*/
void yon_open_browser(GtkWidget *self, char *link);

char *yon_debug_output(char *pattern,char*text);

/**yon_ubl_connect_config(_template_config *config)
 * [EN]
 * 
 * [RU]
 * Присоединяет конфиг основной утилиты (struct config) к стандартному интерфейсу. 
*/
int yon_ubl_connect_config(_template_config *config);

void yon_root_button_setup(template_main_window *widgets, config_str args, int args_size);

/**yon_ubl_window_init(int argc, char *argv[])
 * [EN]
 * 
 * [RU]
 * Создаёт и настраивает основное окно приложения.
*/
template_main_window *yon_ubl_window_setup();

/**yon_ubl_window_setup(GtkWidget *interface, char *app_title, char *app_description, char *locale, char *css, char *tech_name, char *version, char *wiki)
 * [EN]
 * 
 * [RU]
 * Установить важные значения для конфига;
 * [app_title] - оботражаемое имя утилиты;
 * [app_description] - отображаемое описание утилиты;
 * [css] - путь к ресурсу css файла;
 * [tech_name] - техническое имя утилиты (ubl-settings-)
 * [version] - строка с версией приложения;
 * [wiki] - ссылка на вики страницу; 
*/
int yon_ubl_window_init(char *app_title, char *app_description, char *locale, char *css, char *tech_name, char *version, char *wiki);

/**on_about()
 * [EN]
 * Function for setting up and showing AboutDialog.
 * Connect it to "activate" signal of Documentation MenuItem.
 * [RU]
 * Функиця для настройки и показа окна AboutDialog.
 * Присоединять к сигналу "activate" кнопки справки типа MenuItem.
*/
void on_about(GtkWidget *self, char *version_application);

/**on_open_documentation_confirmation(GtkWidget *self, char *link)
 * [EN]
 * Opens confirmation window for [link] link.
 * [RU]
 * Открывает окно подтверждения перехода по ссылке [link].
*/
void on_open_documentation_confirmation(GtkWidget *self, char *link);

void yon_entry_set_entry_type(GtkEntry *target,GtkBox *status);

int yon_ubl_setup_arguments(int argc, char *argv[],config_str *unfound_arguments, int *arguments_size, char *additional_options_output);

void yon_gtk_scrolled_window_set_horizontal_at_desired_size(GtkWidget *window, GtkScrolledWindow *target);

template_app_info yon_ubl_get_app_info();

void yon_ubl_settings_window_set_standard_callbacks(template_main_window *widgets, char *get_global_command, char *get_local_command,char *get_custom_command, char *get_default_command, char *get_global_only_command, char *get_local_only_command);

void yon_window_remove_exit_config_check(template_main_window *widgets);

void yon_window_set_exit_config_check(template_main_window *widgets, GCallback data_callback_function);

typedef struct {
    GtkWidget *Window;
    GtkWidget *HeaderTopic;
    GtkWidget *HeaderImage;
    GtkWidget *StatusBox;
    GtkWidget *ParametersTree;
    GtkCellRenderer *ToggleCell;
    GtkWidget *CancelButton;
    GtkWidget *SaveButton;
    GtkListStore *list;
    GtkTreeModel *filteredModel;
    GtkTreeViewColumn *OldValueColumn;
    GtkCellRenderer *OldValueCell;
    GtkTreeViewColumn *NewValueColumn;
    GtkCellRenderer *NewValueCell;
    YON_CONFIG_TYPE type;
    char *custom_save_path;
} template_saving_window;

void yon_save_window_set_presave_function(void *function, void *data);

void yon_save_window_set_postsave_function(void *function, void *data);

void yon_save_window_set_postsave_failure_function(void *function, void *data);

char *yon_get_default_label_with_parameter(char *command);

enum YON_SAVE_COLUMNS {
    YON_SAVE_CHECKED,
    YON_SAVE_PARAMETER,
    YON_SAVE_OLD,
    YON_SAVE_NEW,
    YON_SAVE_COMPARE,
    YON_SAVE_COLOR,
    YON_SAVE_VISIBLE,
    YON_SAVE_SECTION
};

template_saving_window *yon_save_proceed(char *path,YON_CONFIG_TYPE type, ...);

void yon_on_space_first_changed(GtkEntry *editable);


enum CONFIGURATION_PARAMETER_TYPE{
    CONFIGURATION_PARAMETER_BOOL,
    CONFIGURATION_PARAMETER_ENTRY,
    CONFIGURATION_PARAMETER_COMBO_BOX,
    CONFIGURATION_PARAMETER_LIST_MULTIPLE
};

void yon_ubl_settings_window_init(GtkMenu *menu);
void *yon_ubl_settings_window_get(char *id);
void yon_configuration_window_add_boolean_parameter(enum CONFIGURATION_PARAMETER_TYPE type, char *id, char *label);
void yon_configuration_window_add_combo_box_parameter(enum CONFIGURATION_PARAMETER_TYPE type, char *id, char *label, GCallback func, gpointer data, ...);
template_saving_window *yon_exit_window_new();

char *yon_gtk_entry_check_restricted(GtkEntry *target);

typedef struct {
    GtkWidget *window;
    GtkWidget *WorkZoneBox;
    GtkWidget *AcceptButton;
    GtkWidget *CancelButton;
} ubl_settings_window;

char *yon_settings_configuration_get(char *id);
char *yon_custom_config_init();

typedef struct {
    GtkWidget *MainWindow;
    GtkWidget *StatusBox;
    GtkWidget *HeadLabel;
    GtkWidget *TitleLabel;
    
    GtkWidget *UpdateButton;
    GtkWidget *StatusButton;

    GtkWidget *ActiveLabel;
    GtkWidget *EnableLabel;
    GtkWidget *ActiveImage;
    GtkWidget *EnableImage;

    GtkWidget *RestartButton;
    GtkWidget *StartButton;
    GtkWidget *StopButton;
    GtkWidget *EnableButton;
    GtkWidget *DisableButton;

    char *name;
    char *start_command;
    char *stop_command;
    char *enable_command;
    char *disable_command;
    char *info_command;
    char *check_active_command;
    char *check_enable_command;
} service_window;

typedef struct {
    GtkWidget *MainWindow;
    GtkWidget *StatusBox;
    GtkWidget *HeadLabel;
    GtkWidget *WindowImage;

    GtkWidget *CancelButton;
    GtkWidget *AcceptButton;

    GtkWidget *MainTree;
    GtkCellRenderer *SelectionCell;
    GtkTreeStore *treestore;
    
    GtkWidget *MainIconView;
    GtkListStore *liststore;

    int apps_size;
    config_str apps;

    dictionary *apps_convert;

    struct return_struct *final;

    int multiple;
    int visible_allowed;
} yon_app_chooser_window;

service_window *yon_service_window_new(char *name, char *start_command,
                                        char *stop_command, char *enable_command,
                                        char *disable_command, char *info_command,
                                        char *check_active_command, char *check_enable_command);
void yon_service_window_run(service_window *window);

int yon_app_chooser_window_select(yon_app_chooser_window *window,config_str selection,int size);
config_str yon_app_chooser_window_run(yon_app_chooser_window *window, int *size);
yon_app_chooser_window *yon_app_chooser_window_new(int multiple_choise);

typedef struct {
    GtkWidget *Window;
    GtkWidget *HeadLabel;
    GtkWidget *StatusBox;

    GtkWidget *PasswordEntry;
    GtkWidget *RepeatPasswordEntry;
    GtkWidget *EncryptionCombo;
    GtkWidget *NoEncriptionCheck;
    GtkWidget *PasswordHashEntry;
    GtkWidget *UserCancelButton;
    GtkWidget *AcceptButton;

    GtkWidget *PasswordBox;
    GtkWidget *HashBox;

    const char *old_password;
} yon_password_window;

/// @brief 
/// @param window окно с паролем
/// @param hashes массив с названиями типов хэша
/// @param get_hash_commands массив с командами получения хэша. Если команда == NULL, получение хэша пароля блокируется
/// @param size размер hashes и get_hash_commands. Оба массива должны быть одного размера
void yon_password_hash_list_set(yon_password_window *window, config_str hashes, config_str get_hash_commands, int size);

yon_password_window *yon_password_open(GtkEntry *target);

    #define VERSION_LABEL yon_char_unite(_("Version:")," ",!yon_char_is_empty(template_app_information.app_version)?template_app_information.app_version:"","\n",NULL)
    #define HELP_LABEL(rest) yon_char_unite(template_app_information.app_tech_name,_(" version:")," ", !yon_char_is_empty(template_app_information.app_version)?template_app_information.app_version:"","\n",\
    template_app_information.app_title,"\n",_("Usage:"), " ",template_app_information.app_tech_name," ",_("[OPTIONS]"),"\n",\
    _("Options:"),"\n",\
    "   --help, -h              ",_("Show this help"),"\n",\
    "   --version, -V           ",_("Show package version"),"\n",\
    "   --lock-help             ",_("Lock this help menu"),"\n",\
    "   --lock-save             ",_("Lock configuration saving"),"\n",\
    "   --lock-save-local       ",_("Lock local configration saving"),"\n",\
    "   --lock-save-global      ",_("Lock global configration saving"),"\n",\
    "   --lock-load-global      ",_("Lock global configration loading"),"\n",\
    "   --clear-config, -c      ",_("Reset application settings"),"\n",\
    !yon_char_is_empty(rest)?rest:NULL,NULL)

    #define template_ui_LocalePath "/usr/share/locale" 
    #define template_ui_LocaleName "libublsettingsui-gtk3"

    #define about_label(target) yon_char_unite(yon_char_get_localised_from_lib(_("About"))," ",target,NULL)

    #define SUCCESS_LABEL _("Operation succeeded")
    #define FAIL_LABEL _("Operation failed")
    #define ROOT_WARNING_LABEL _("Warning! Application was launched without root - root-dependent actions are locked")

    #define DEFAULT_LABEL _("Default")
    #define DEFAULT_CUSTOM_LABEL(target) yon_char_unite(_("Default"),!yon_char_is_empty(target)?" (":NULL,target,")",NULL)
    #define ABOUT_LABEL _("About")
    #define DOCUMENTATION_LABEL _("Documentation")

    #define SAVE_CUSTOM_LABEL _("Save to specific file")
    #define SAVE_LOCAL_LABEL _("Save to local configuration")
    #define SAVE_GLOBAL_LABEL _("Save to global configuration")
    #define SAVE_CONFIGURATION_LABEL _("Save configuration")
    #define SAVE_LABEL _("Save")
    #define SAVE_PROCESS_LABEL _("Saving...")

    #define LOAD_CUSTOM_LABEL _("Load from specific file")
    #define LOAD_LOCAL_LABEL _("Load local configuration")
    #define LOAD_GLOBAL_LABEL _("Load global configuration")
    #define LOAD_LABEL _("Load")
    #define LOAD_CONFIG_LABEL _("Load file")

    #define CANCEL_LABEL _("Cancel")
    #define ACCEPT_LABEL _("Accept")
    #define OPEN_LABEL _("Open")
    #define CREATE_FOLDER_LABEL _("Create directory")
    #define SELECT_FOLDER_LABEL _("Select directory")

    #define HELP_TITLE_LABEL _("Would you like to read documentation in the Web?")
    #define HELP_INFO_LABEL _("You will be redirected to documentation website where documentation is\ntranslated and supported by community.")
    #define HELP_ALWAYS_OPEN_LABEL _("Always redirect to online documentation")
    #define OPEN_HELP_LABEL _("Open documentation")
    #define PROJECT_HOME_LABEL _("Project Home Page")
    #define NOTHING_CHOSEN_LABEL _("Nothing were chosen")
    #define AUTHORS_LABEL _(L"Copyright © 2022 - 2025, UBSoft LLC")


    #define GLOBAL_LOAD_SUCCESS_LABEL _("Global configuration loading succeeded.")
    #define LOCAL_LOAD_SUCCESS_LABEL _("Local configuration loading succeeded.")
    #define LOAD_FAILED_LABEL _("Config loading failed")

    #define GLOBAL_LOCAL_SAVE_SUCCESS_LABEL _("Local and global configuration saving succeeded.")
    #define GLOBAL_SAVE_SUCCESS_LABEL _("Global configuration saving succeeded.")
    #define LOCAL_SAVE_SUCCESS_LABEL _("Local configuration saving succeeded.")
    #define SAVE_SUCCESS_LABEL _("Configuration saving succeeded.")

    #define PARAMETER_LABEL _("Parameter")
    #define OLD_VALUE_LABEL _("Old value")
    #define NEW_VALUE_LABEL _("New value")
    #define COMPARE_VALUE_LABEL _("Value\n(Old/New)")

    #define NOTHING_TO_SAVE_LABEL _("Nothing to save")
    #define SAVING_LOCAL_STATE_LABEL _("Saving into local configuration")
    #define SAVING_GLOBAL_STATE_LABEL _("Saving into global configuration")
    #define SAVING_GLOBAL_LOCAL_STATE_LABEL _("Saving into global and local configuration")
    #define SAVING_CUSTOM_STATE_LABEL(target_path) yon_char_unite(_("Saving into custom configuration at")," ",target_path,NULL)

    #define SYSTEMBOOT_STATEMODE "SYSTEMBOOT_STATEMODE"
    #define SYSTEMBOOT_STATEMODE_SECTION "[system]"

    #define SAVE_MODE_FULL_LABEL _("Full saving mode")
    #define SAVE_MODE_MODULE_LABEL _("Saving into module")
    #define SAVE_MODE_SANDBOX_LABEL _("Sandbox mode")
    #define SAVE_MODE_RAM_HOME_LABEL _("Sandbox with profile saving")
    #define SAVE_MODE_HDD_LABEL _("HDD sandbox")
    #define SAVE_MODE_HDD_HOME_LABEL _("HDD sandbox with profile saving")
    #define CUSTOM_CONFIG_CREATION_ERROR_LABEL _("New configuration file creation failed")
    #define ROOT_CHECK_LABEL _("Upgrade to root")
    #define SETTINGS_TITLE_LABEL _("Settings")

    #define CONFIG_WINDOW_MENU_LABEL _("Application settigs")

    #define EMAIL_INVALID_LABEL _("Invalid email adress")
    #define PATH_INVALID_LABEL _("Invalid path")

    #define CHOOSE_FILE_LABEL _("Choose path")
    #define CHOOSE_APP_LABEL _("Choose application")
    

    #define FILE_CHOOSER_CHOOSE_FILDER_LABEL _("Choose directory instead of file")

    #define _SERVICE_ENABLE_LABEL _("Enabled")
    #define _SERVICE_DISABLE_LABEL _("Disabled")
    #define _SERVICE_ACTIVE_LABEL _("Active")
    #define _SERVICE_INACTIVE_LABEL _("Inactive")

    #define _SERVICE_ACTIVE_TEXT_LABEL _("Active:")
    #define _SERVICE_ENABLED_TEXT_LABEL _("Enabled:")
    #define _SERVICE_START_BUTTON_LABEL _("Start")
    #define _SERVICE_STOP_BUTTON_LABEL _("Stop")
    #define _SERVICE_RESTART_BUTTON_LABEL _("Restart")
    
    #define _SERVICE_ENABLE_BUTTON_LABEL _("Enable autolaunch")
    #define _SERVICE_DISABLE_BUTTON_LABEL _("Disable autolaunch")

    #define _SERVICE_HEAD_LABEL(target) g_strdup_printf(yon_char_get_localised_from_lib(_("\"%s\" service configuration")), target)
    #define _SERVICE_TITLE_LABEL(target) g_strdup_printf(yon_char_get_localised_from_lib(_("\"%s\" service:")), target)
    #define _SERVICE_ACTIVE_STATUS_LABEL(target) yon_char_unite("\"",target,"\" ", yon_char_get_localised_from_lib(_("service is active")),NULL)
    #define _SERVICE_INACTIVE_STATUS_LABEL(target) yon_char_unite("\"",target,"\" ",yon_char_get_localised_from_lib(_("service is inactive")),NULL)

    #define _PASSWORD_TITLE_LABEL yon_char_get_localised_from_lib("Password")

    #define UNSAVED_LABEL yon_char_get_localised_from_lib("The changes were not saved to either the local or global configuration file.\nQuit without saving?")
    #define EXIT_LABEL yon_char_get_localised_from_lib("Exit")

    #define _PASSWORD_MISMATCH_LABEL yon_char_get_localised_from_lib("Passwords do not match")
    #define _PASSWORD_RESTRICTED_SYMBOL_LABEL yon_char_get_localised_from_lib("Password contains restricted symbols")
    #define _EMPTY_IMPORTANT_LABEL yon_char_get_localised_from_lib("Empty important field!")
    #define _INCORRECT_HASH_LABEL yon_char_get_localised_from_lib("Invalid hash")
    #define _ENCRYPTION_DEFAULT_LABEL yon_char_get_localised_from_lib("Default (None)")
    #define ACCESS_DENIED_LABEL(target) yon_char_unite(yon_char_get_localised_from_lib("Access to file denied"),": ", target,NULL)
#endif