@php use App\Models\Repository;use Illuminate\Support\MessageBag;
/**
 * @var Repository $repository
 * @var MessageBag $errors
 */
@endphp
@extends('layout.base_layout')

@section('content')

    @include('layout.sidebar_nav')

    <div class="col">

        <div class="d-flex justify-content-between border-bottom my-3">

            <h3 class="page_title">
                {{$repository->title}}
                <i class="bi bi-arrow-right-short text-muted"></i>
                Редактировать репозиторий
            </h3>

            <div>
                @can('delete_repositories')
                    <form method="POST" action="{{route("repository_delete")}}">
                        @csrf
                        <input type="hidden" name="id" value="{{$repository->id}}">
                        <input type="hidden" name="project_id" value="{{$repository->project_id}}">

                        <button type="submit" class="btn btn-sm  btn-danger">
                            <i class="bi bi-trash3"></i>
                            Удалить
                        </button>
                    </form>
                @endcan
            </div>

        </div>

        @if ($errors->any())
            <div class="alert alert-danger">
                <strong>Упс!</strong> С вашим вводом возникли некоторые проблемы.<br><br>
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <div class="base_block shadow p-4">
            <form method="POST" action="{{route('repository_update')}}">
                @csrf

                <input type="hidden" name="id" value="{{$repository->id}}">
                <input type="hidden" name="project_id" value="{{$repository->project_id}}">

                <div class="mb-3">
                    <label for="title" class="form-label">Имя</label>
                    <input type="text" class="form-control" name="title" required maxlength="100"
                           value="{{$repository->title}}">
                </div>

                <div class="mb-3">
                    <label for="prefix" class="form-label">Префикс <span
                                class="text-muted">(максимально 3 символа)</span></label>
                    <input type="text" class="form-control" name="prefix"
                           required maxlength="3"
                           pattern="[^\s]+" title="пожалуйста, не используйте пробелы :)"
                           style="text-transform:uppercase"
                           value="{{$repository->prefix}}">
                </div>

                <div class="mb-3">
                    <label for="description" class="form-label">Описание</label>
                    <textarea class="form-control" name="description"
                              maxlength="255">{{$repository->description}}</textarea>
                </div>


                <button type="submit" class="btn btn-warning px-5 me-2">
                    <b>Обновить</b>
                </button>

                <a href="{{ url()->previous() }}" class="btn btn-outline-dark px-5">
                    <b>Отменить</b>
                </a>
            </form>
        </div>


    </div>

@endsection

