#!/usr/bin/env bash
#
# Author: Dmitry Razumov <asmeron@ublinux.com>
# Copyright (c) 2021-2025 UBLinux <support@ublinux.com>
#

unset ROOTFS && [[ -d /usr/lib/ublinux ]] || ROOTFS="."

#/etc/rc.d
INITD=${ROOTFS}/etc/init.d
[[ -d ${INITD} ]] || INITD=${ROOTFS}/etc/rc.d/init.d
if [[ -d ${INITD} && -d ${ROOTFS}/usr/lib/ublinux/rc.d/init.d ]]; then
    find ${ROOTFS}/usr/lib/ublinux/rc.d/init.d -type f | sed s%${ROOTFS}/usr/lib/ublinux/rc.d/init.d/%% | while read FILE_INITD; do
        ln -sf /usr/lib/ublinux/rc.d/init.d/${FILE_INITD} ${INITD}
    done
fi

#systemd
SYSTEMDFILES=${ROOTFS}/usr/lib/systemd/system
[[ -d ${SYSTEMDFILES} ]] || SYSTEMDFILES=${ROOTFS}/lib/systemd/system
if [[ -d ${SYSTEMDFILES} && -d ${ROOTFS}/usr/lib/ublinux/systemd ]]; then
    find ${ROOTFS}/usr/lib/ublinux/systemd -type f | sed s%${ROOTFS}/usr/lib/ublinux/systemd/%% | while read FILE_SYSTEMD; do
        ln -sf /usr/lib/ublinux/systemd/${FILE_SYSTEMD} ${SYSTEMDFILES}
    done
fi
if [[ -d ${SYSTEMDFILES} && -d ${ROOTFS}/usr/lib/ublinux/systemd ]]; then
    ls -1d ${ROOTFS}/usr/lib/ublinux/systemd/*.wants | sed s%${ROOTFS}/usr/lib/ublinux/systemd/%% | while read FILE_SYSTEMD; do
        [[ -d ${SYSTEMDFILES}/${FILE_SYSTEMD} ]] || mkdir -p ${SYSTEMDFILES}/${FILE_SYSTEMD}
        cp -df ${ROOTFS}/usr/lib/ublinux/systemd/${FILE_SYSTEMD}/* ${SYSTEMDFILES}/${FILE_SYSTEMD}
    done
fi

ln -sf /usr/lib/ublinux/rc.d/rc.xorg ${ROOTFS}/etc/X11/xinit/xinitrc.d/00-ublinux-rc-xorg

cat > ${ROOTFS}/etc/xdg/autostart/ublinux-rc.desktop << EOF
[Desktop Entry]
Categories=
Comment=Run applications at system start
Comment[ru]=Автозапуск приложений при старте
Exec=/usr/lib/ublinux/rc.d/rc.desktop
GenericName[ru]=
GenericName=
Icon=
MimeType=
Name=UBLinux autoexec
Name[ru]=Автозапуск UBLinux
Path=
StartupNotify=false
Terminal=false
Type=Application
X-DBUS-ServiceName=
X-DBUS-StartupType=unique
X-KDE-StartupNotify=false
X-KDE-SubstituteUID=false
X-KDE-Username=
EOF

true
