/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.isolation;

import java.util.Collections;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.kafka.connect.runtime.isolation.LoaderSwap;
import org.apache.kafka.connect.runtime.isolation.PluginDesc;
import org.apache.kafka.connect.runtime.isolation.PluginScanResult;
import org.apache.kafka.connect.runtime.isolation.PluginScanner;
import org.apache.kafka.connect.runtime.isolation.PluginSource;
import org.apache.kafka.connect.runtime.isolation.PluginType;
import org.apache.kafka.connect.runtime.isolation.PluginUtils;
import org.apache.kafka.connect.transforms.Transformation;
import org.apache.kafka.connect.transforms.predicates.Predicate;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.ReflectionsException;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionScanner
extends PluginScanner {
    private static final Logger log = LoggerFactory.getLogger(ReflectionScanner.class);

    private static <T> String versionFor(Class<? extends T> pluginKlass) throws ReflectiveOperationException {
        T pluginImpl = pluginKlass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        return ReflectionScanner.versionFor(pluginImpl);
    }

    @Override
    protected PluginScanResult scanPlugins(PluginSource source) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.setClassLoaders(new ClassLoader[]{source.loader()});
        builder.addUrls(source.urls());
        builder.setScanners(new Scanner[]{Scanners.SubTypes});
        builder.setParallel(true);
        Reflections reflections = new Reflections((Configuration)builder);
        return new PluginScanResult(this.getPluginDesc(reflections, PluginType.SINK, source), this.getPluginDesc(reflections, PluginType.SOURCE, source), this.getPluginDesc(reflections, PluginType.CONVERTER, source), this.getPluginDesc(reflections, PluginType.HEADER_CONVERTER, source), this.getTransformationPluginDesc(source, reflections), this.getPredicatePluginDesc(source, reflections), this.getServiceLoaderPluginDesc(PluginType.CONFIGPROVIDER, source), this.getServiceLoaderPluginDesc(PluginType.REST_EXTENSION, source), this.getServiceLoaderPluginDesc(PluginType.CONNECTOR_CLIENT_CONFIG_OVERRIDE_POLICY, source));
    }

    private SortedSet<PluginDesc<Predicate<?>>> getPredicatePluginDesc(PluginSource source, Reflections reflections) {
        return this.getPluginDesc(reflections, PluginType.PREDICATE, source);
    }

    private SortedSet<PluginDesc<Transformation<?>>> getTransformationPluginDesc(PluginSource source, Reflections reflections) {
        return this.getPluginDesc(reflections, PluginType.TRANSFORMATION, source);
    }

    private <T> SortedSet<PluginDesc<T>> getPluginDesc(Reflections reflections, PluginType type, PluginSource source) {
        Set plugins;
        try {
            plugins = reflections.getSubTypesOf(type.superClass());
        }
        catch (ReflectionsException e) {
            log.debug("Reflections scanner could not find any {} in {} for URLs: {}", new Object[]{type, source, source.urls(), e});
            return Collections.emptySortedSet();
        }
        TreeSet<PluginDesc<T>> result = new TreeSet<PluginDesc<T>>();
        for (Class pluginKlass : plugins) {
            if (!PluginUtils.isConcrete(pluginKlass)) {
                log.debug("Skipping {} in {} as it is not concrete implementation", (Object)pluginKlass, (Object)source);
                continue;
            }
            if (pluginKlass.getClassLoader() != source.loader()) {
                log.debug("{} from other classloader {} is visible from {}, excluding to prevent isolated loading", new Object[]{pluginKlass, pluginKlass.getClassLoader(), source});
                continue;
            }
            try {
                LoaderSwap loaderSwap = this.withClassLoader(source.loader());
                try {
                    result.add(this.pluginDesc(pluginKlass, ReflectionScanner.versionFor(pluginKlass), type, source));
                }
                finally {
                    if (loaderSwap == null) continue;
                    loaderSwap.close();
                }
            }
            catch (LinkageError | ReflectiveOperationException e) {
                log.error("Failed to discover {} in {}: Unable to instantiate {}{}", new Object[]{type.simpleName(), source, pluginKlass.getSimpleName(), ReflectionScanner.reflectiveErrorDescription(e), e});
            }
        }
        return result;
    }
}

