/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.log.LogManager;
import kafka.server.BrokerLifecycleManager;
import kafka.server.BrokerReconfigurable;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import kafka.server.RequestLocal$;
import kafka.server.metadata.AclPublisher;
import kafka.server.metadata.BrokerMetadataPublisher$;
import kafka.server.metadata.DelegationTokenPublisher;
import kafka.server.metadata.DynamicClientQuotaPublisher;
import kafka.server.metadata.DynamicConfigPublisher;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.server.metadata.ScramPublisher;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.coordinator.group.GroupCoordinator;
import org.apache.kafka.image.FeaturesDelta;
import org.apache.kafka.image.LocalReplicaChanges;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicDelta;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsDelta;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.publisher.MetadataPublisher;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.fault.FaultHandler;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0005\t\u0015s!B\u0013'\u0011\u0003ic!B\u0018'\u0011\u0003\u0001\u0004\"B\u001f\u0002\t\u0003q\u0004\"B \u0002\t\u0003\u0001e\u0001B\u0018'\u0001\u0019D\u0001\"\u001e\u0003\u0003\u0002\u0003\u0006IA\u001e\u0005\tu\u0012\u0011\t\u0011)A\u0005w\"Aa\u0010\u0002B\u0001B\u0003%q\u0010\u0003\u0006\u0002\f\u0011\u0011\t\u0011)A\u0005\u0003\u001bA!\"a\u0005\u0005\u0005\u0003\u0005\u000b\u0011BA\u000b\u0011)\t)\u0003\u0002B\u0001B\u0003%\u0011q\u0005\u0005\u000b\u0003k!!\u00111A\u0005\u0002\u0005]\u0002BCA \t\t\u0005\r\u0011\"\u0001\u0002B!Q\u0011Q\n\u0003\u0003\u0002\u0003\u0006K!!\u000f\t\u0015\u0005=CA!A!\u0002\u0013\t\t\u0006\u0003\u0006\u0002X\u0011\u0011\t\u0011)A\u0005\u00033B!\"a\u0018\u0005\u0005\u0003\u0005\u000b\u0011BA1\u0011)\t9\u0007\u0002B\u0001B\u0003%\u0011\u0011\u000e\u0005\u000b\u0003_\"!\u0011!Q\u0001\n\u0005E\u0004BCA@\t\t\u0005\t\u0015!\u0003\u0002r!Q\u0011\u0011\u0011\u0003\u0003\u0002\u0003\u0006I!a!\t\ru\"A\u0011AAE\u0011%\tI\u000b\u0002b\u0001\n\u0003\tY\u000b\u0003\u0005\u00024\u0012\u0001\u000b\u0011BAW\u0011%\t)\f\u0002a\u0001\n\u0003\t9\fC\u0005\u0002@\u0012\u0001\r\u0011\"\u0001\u0002B\"A\u0011Q\u0019\u0003!B\u0013\tI\fC\u0005\u0002H\u0012\u0011\r\u0011\"\u0001\u0002J\"A\u0011\u0011\u001d\u0003!\u0002\u0013\tY\rC\u0004\u0002d\u0012!\t%!:\t\u000f\u0005\u001dH\u0001\"\u0011\u0002j\"9\u0011q \u0003\u0005\n\t\u0005\u0001b\u0002B\t\t\u0011\u0005!1\u0003\u0005\b\u0005?!A\u0011\u0001B\u0011\u0011\u001d\u0011I\u0004\u0002C\u0005\u0005wAqAa\u0010\u0005\t\u0013\u0011\t\u0005C\u0004\u0003D\u0011!\tE!\u0011\u0002/\t\u0013xn[3s\u001b\u0016$\u0018\rZ1uCB+(\r\\5tQ\u0016\u0014(BA\u0014)\u0003!iW\r^1eCR\f'BA\u0015+\u0003\u0019\u0019XM\u001d<fe*\t1&A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u00059\nQ\"\u0001\u0014\u0003/\t\u0013xn[3s\u001b\u0016$\u0018\rZ1uCB+(\r\\5tQ\u0016\u00148cA\u00012oA\u0011!'N\u0007\u0002g)\tA'A\u0003tG\u0006d\u0017-\u0003\u00027g\t1\u0011I\\=SK\u001a\u0004\"\u0001O\u001e\u000e\u0003eR!A\u000f\u0016\u0002\u000bU$\u0018\u000e\\:\n\u0005qJ$a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00035\nQbZ3u)>\u0004\u0018n\u0019#fYR\fG\u0003B!P9\u0006\u00042A\r\"E\u0013\t\u00195G\u0001\u0004PaRLwN\u001c\t\u0003\u000b6k\u0011A\u0012\u0006\u0003\u000f\"\u000bQ![7bO\u0016T!aK%\u000b\u0005)[\u0015AB1qC\u000eDWMC\u0001M\u0003\ry'oZ\u0005\u0003\u001d\u001a\u0013!\u0002V8qS\u000e$U\r\u001c;b\u0011\u0015\u00016\u00011\u0001R\u0003%!x\u000e]5d\u001d\u0006lW\r\u0005\u0002S3:\u00111k\u0016\t\u0003)Nj\u0011!\u0016\u0006\u0003-2\na\u0001\u0010:p_Rt\u0014B\u0001-4\u0003\u0019\u0001&/\u001a3fM&\u0011!l\u0017\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005a\u001b\u0004\"B/\u0004\u0001\u0004q\u0016\u0001\u00038fo&k\u0017mZ3\u0011\u0005\u0015{\u0016B\u00011G\u00055iU\r^1eCR\f\u0017*\\1hK\")!m\u0001a\u0001G\u0006)A-\u001a7uCB\u0011Q\tZ\u0005\u0003K\u001a\u0013Q\"T3uC\u0012\fG/\u0019#fYR\f7\u0003\u0002\u0003h_^\u0002\"\u0001[7\u000e\u0003%T!A[6\u0002\t1\fgn\u001a\u0006\u0002Y\u0006!!.\u0019<b\u0013\tq\u0017N\u0001\u0004PE*,7\r\u001e\t\u0003aNl\u0011!\u001d\u0006\u0003e\u001a\u000b\u0011\u0002];cY&\u001c\b.\u001a:\n\u0005Q\f(!E'fi\u0006$\u0017\r^1Qk\nd\u0017n\u001d5fe\u000611m\u001c8gS\u001e\u0004\"a\u001e=\u000e\u0003!J!!\u001f\u0015\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u000e[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0011\u00059b\u0018BA?'\u0005IY%+\u00194u\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0002\u00151|w-T1oC\u001e,'\u000f\u0005\u0003\u0002\u0002\u0005\u001dQBAA\u0002\u0015\r\t)AK\u0001\u0004Y><\u0017\u0002BA\u0005\u0003\u0007\u0011!\u0002T8h\u001b\u0006t\u0017mZ3s\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u00042a^A\b\u0013\r\t\t\u0002\u000b\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003A9'o\\;q\u0007>|'\u000fZ5oCR|'\u000f\u0005\u0003\u0002\u0018\u0005\u0005RBAA\r\u0015\u0011\tY\"!\b\u0002\u000b\u001d\u0014x.\u001e9\u000b\u0007\u0005}\u0001*A\u0006d_>\u0014H-\u001b8bi>\u0014\u0018\u0002BA\u0012\u00033\u0011\u0001c\u0012:pkB\u001cun\u001c:eS:\fGo\u001c:\u0002\u001dQDhnQ8pe\u0012Lg.\u0019;peB!\u0011\u0011FA\u0019\u001b\t\tYC\u0003\u0003\u0002.\u0005=\u0012a\u0003;sC:\u001c\u0018m\u0019;j_:T1!a\b+\u0013\u0011\t\u0019$a\u000b\u0003-Q\u0013\u0018M\\:bGRLwN\\\"p_J$\u0017N\\1u_J\fa\u0003Z=oC6L7mQ8oM&<\u0007+\u001e2mSNDWM]\u000b\u0003\u0003s\u00012ALA\u001e\u0013\r\tiD\n\u0002\u0017\tft\u0017-\\5d\u0007>tg-[4Qk\nd\u0017n\u001d5fe\u0006QB-\u001f8b[&\u001c7i\u001c8gS\u001e\u0004VO\u00197jg\",'o\u0018\u0013fcR!\u00111IA%!\r\u0011\u0014QI\u0005\u0004\u0003\u000f\u001a$\u0001B+oSRD\u0011\"a\u0013\r\u0003\u0003\u0005\r!!\u000f\u0002\u0007a$\u0013'A\fes:\fW.[2D_:4\u0017n\u001a)vE2L7\u000f[3sA\u0005YB-\u001f8b[&\u001c7\t\\5f]R\fVo\u001c;b!V\u0014G.[:iKJ\u00042ALA*\u0013\r\t)F\n\u0002\u001c\tft\u0017-\\5d\u00072LWM\u001c;Rk>$\u0018\rU;cY&\u001c\b.\u001a:\u0002\u001dM\u001c'/Y7Qk\nd\u0017n\u001d5feB\u0019a&a\u0017\n\u0007\u0005ucE\u0001\bTGJ\fW\u000eU;cY&\u001c\b.\u001a:\u00021\u0011,G.Z4bi&|g\u000eV8lK:\u0004VO\u00197jg\",'\u000fE\u0002/\u0003GJ1!!\u001a'\u0005a!U\r\\3hCRLwN\u001c+pW\u0016t\u0007+\u001e2mSNDWM]\u0001\rC\u000ed\u0007+\u001e2mSNDWM\u001d\t\u0004]\u0005-\u0014bAA7M\ta\u0011i\u00197Qk\nd\u0017n\u001d5fe\u0006\tb-\u0019;bY\u001a\u000bW\u000f\u001c;IC:$G.\u001a:\u0011\t\u0005M\u00141P\u0007\u0003\u0003kRA!a\u001e\u0002z\u0005)a-Y;mi*\u0011\u0011\u0006S\u0005\u0005\u0003{\n)H\u0001\u0007GCVdG\u000fS1oI2,'/\u0001\u0010nKR\fG-\u0019;b!V\u0014G.[:iS:<g)Y;mi\"\u000bg\u000e\u001a7fe\u00061\"M]8lKJd\u0015NZ3ds\u000edW-T1oC\u001e,'\u000fE\u0002x\u0003\u000bK1!a\")\u0005Y\u0011%o\\6fe2Kg-Z2zG2,W*\u00198bO\u0016\u0014HCHAF\u0003\u001b\u000by)!%\u0002\u0014\u0006U\u0015qSAM\u00037\u000bi*a(\u0002\"\u0006\r\u0016QUAT!\tqC\u0001C\u0003v+\u0001\u0007a\u000fC\u0003{+\u0001\u00071\u0010C\u0003\u007f+\u0001\u0007q\u0010C\u0004\u0002\fU\u0001\r!!\u0004\t\u000f\u0005MQ\u00031\u0001\u0002\u0016!9\u0011QE\u000bA\u0002\u0005\u001d\u0002bBA\u001b+\u0001\u0007\u0011\u0011\b\u0005\b\u0003\u001f*\u0002\u0019AA)\u0011\u001d\t9&\u0006a\u0001\u00033Bq!a\u0018\u0016\u0001\u0004\t\t\u0007C\u0004\u0002hU\u0001\r!!\u001b\t\u000f\u0005=T\u00031\u0001\u0002r!9\u0011qP\u000bA\u0002\u0005E\u0004bBAA+\u0001\u0007\u00111Q\u0001\tEJ|7.\u001a:JIV\u0011\u0011Q\u0016\t\u0004e\u0005=\u0016bAAYg\t\u0019\u0011J\u001c;\u0002\u0013\t\u0014xn[3s\u0013\u0012\u0004\u0013!D0gSJ\u001cH\u000fU;cY&\u001c\b.\u0006\u0002\u0002:B\u0019!'a/\n\u0007\u0005u6GA\u0004C_>dW-\u00198\u0002#}3\u0017N]:u!V\u0014G.[:i?\u0012*\u0017\u000f\u0006\u0003\u0002D\u0005\r\u0007\"CA&3\u0005\u0005\t\u0019AA]\u00039yf-\u001b:tiB+(\r\\5tQ\u0002\n!CZ5sgR\u0004VO\u00197jg\"4U\u000f^;sKV\u0011\u00111\u001a\t\u0007\u0003\u001b\f9.a7\u000e\u0005\u0005='\u0002BAi\u0003'\f!bY8oGV\u0014(/\u001a8u\u0015\r\t)n[\u0001\u0005kRLG.\u0003\u0003\u0002Z\u0006='!E\"p[BdW\r^1cY\u00164U\u000f^;sKB\u0019\u0001.!8\n\u0007\u0005}\u0017N\u0001\u0003W_&$\u0017a\u00054jeN$\b+\u001e2mSNDg)\u001e;ve\u0016\u0004\u0013\u0001\u00028b[\u0016$\u0012!U\u0001\u0011_:lU\r^1eCR\fW\u000b\u001d3bi\u0016$\u0002\"a\u0011\u0002l\u00065\u0018q\u001e\u0005\u0006Ez\u0001\ra\u0019\u0005\u0006;z\u0001\rA\u0018\u0005\b\u0003ct\u0002\u0019AAz\u0003!i\u0017M\\5gKN$\b\u0003BA{\u0003wl!!a>\u000b\u0007\u0005eh)\u0001\u0004m_\u0006$WM]\u0005\u0005\u0003{\f9P\u0001\bM_\u0006$WM]'b]&4Wm\u001d;\u0002\u001bQ|w\n\u001d;j_:\fG.\u00138u)\u0011\u0011\u0019Aa\u0003\u0011\t\t\u0015!qA\u0007\u0003\u0003'LAA!\u0003\u0002T\nYq\n\u001d;j_:\fG.\u00138u\u0011\u001d\u0011ia\ba\u0001\u0005\u001f\taa\u001c9uS>t\u0007\u0003\u0002\u001aC\u0003[\u000bQE]3m_\u0006$W\u000b\u001d3bi\u0016$g)\u001b7fg^KG\u000f[8vi\u000e{gNZ5h\u0007\"\fgnZ3\u0015\t\u0005\r#Q\u0003\u0005\b\u0005/\u0001\u0003\u0019\u0001B\r\u0003\u0015\u0001(o\u001c9t!\u0011\u0011)Aa\u0007\n\t\tu\u00111\u001b\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018!E;qI\u0006$XmQ8pe\u0012Lg.\u0019;peRa\u00111\tB\u0012\u0005K\u00119C!\u000b\u00034!)q)\ta\u0001=\")!-\ta\u0001G\")\u0001+\ta\u0001#\"9!1F\u0011A\u0002\t5\u0012\u0001C3mK\u000e$\u0018n\u001c8\u0011\u0013I\u0012y#!,\u0002.\u0006\r\u0013b\u0001B\u0019g\tIa)\u001e8di&|gN\r\u0005\b\u0005k\t\u0003\u0019\u0001B\u001c\u0003-\u0011Xm]5h]\u0006$\u0018n\u001c8\u0011\u0013I\u0012y#!,\u0003\u0010\u0005\r\u0013AE5oSRL\u0017\r\\5{K6\u000bg.Y4feN$B!a\u0011\u0003>!)QL\ta\u0001=\u0006\u0001c-\u001b8jg\"Le.\u001b;jC2L'0\u001b8h%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s)\t\t\u0019%A\u0003dY>\u001cX\r")
public class BrokerMetadataPublisher
implements MetadataPublisher,
Logging {
    private final KafkaConfig config;
    private final KRaftMetadataCache metadataCache;
    private final LogManager logManager;
    private final ReplicaManager replicaManager;
    private final GroupCoordinator groupCoordinator;
    private final TransactionCoordinator txnCoordinator;
    private DynamicConfigPublisher dynamicConfigPublisher;
    private final DynamicClientQuotaPublisher dynamicClientQuotaPublisher;
    private final ScramPublisher scramPublisher;
    private final DelegationTokenPublisher delegationTokenPublisher;
    private final AclPublisher aclPublisher;
    private final FaultHandler fatalFaultHandler;
    private final FaultHandler metadataPublishingFaultHandler;
    private final BrokerLifecycleManager brokerLifecycleManager;
    private final int brokerId;
    private boolean _firstPublish;
    private final CompletableFuture<Void> firstPublishFuture;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Option<TopicDelta> getTopicDelta(String topicName, MetadataImage newImage, MetadataDelta delta) {
        return BrokerMetadataPublisher$.MODULE$.getTopicDelta(topicName, newImage, delta);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public void onControllerChange(LeaderAndEpoch x$1) {
        super.onControllerChange(x$1);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public DynamicConfigPublisher dynamicConfigPublisher() {
        return this.dynamicConfigPublisher;
    }

    public void dynamicConfigPublisher_$eq(DynamicConfigPublisher x$1) {
        this.dynamicConfigPublisher = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public boolean _firstPublish() {
        return this._firstPublish;
    }

    public void _firstPublish_$eq(boolean x$1) {
        this._firstPublish = x$1;
    }

    public CompletableFuture<Void> firstPublishFuture() {
        return this.firstPublishFuture;
    }

    public String name() {
        return "BrokerMetadataPublisher";
    }

    public void onMetadataUpdate(MetadataDelta delta, MetadataImage newImage, LoaderManifest manifest) {
        OffsetAndEpoch highestOffsetAndEpoch = newImage.highestOffsetAndEpoch();
        String deltaName = this._firstPublish() ? new StringBuilder(28).append("initial MetadataDelta up to ").append(highestOffsetAndEpoch.offset()).toString() : new StringBuilder(20).append("MetadataDelta up to ").append(highestOffsetAndEpoch.offset()).toString();
        try {
            try {
                if (this.isTraceEnabled()) {
                    this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("Publishing delta ").append(delta).append(" with highest offset ").append(highestOffsetAndEpoch).toString());
                }
                this.metadataCache.setImage(newImage);
                String metadataVersionLogMsg = new StringBuilder(17).append("metadata.version ").append(newImage.features().metadataVersion()).toString();
                if (this._firstPublish()) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("Publishing initial metadata at offset ").append(highestOffsetAndEpoch).append(" with ").append(metadataVersionLogMsg).append(".").toString());
                    this.initializeManagers(newImage);
                } else if (this.isDebugEnabled()) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(37).append("Publishing metadata at offset ").append(highestOffsetAndEpoch).append(" with ").append(metadataVersionLogMsg).append(".").toString());
                }
                Option$.MODULE$.apply((Object)delta.featuresDelta()).foreach((Function1 & Serializable)featuresDelta -> {
                    BrokerMetadataPublisher.$anonfun$onMetadataUpdate$4(this, highestOffsetAndEpoch, delta, featuresDelta);
                    return BoxedUnit.UNIT;
                });
                Option$.MODULE$.apply((Object)delta.topicsDelta()).foreach((Function1 & Serializable)topicsDelta -> {
                    RuntimeException runtimeException;
                    try {
                        $this.replicaManager.applyDelta((TopicsDelta)topicsDelta, newImage);
                    }
                    catch (Throwable t) {
                        $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(31).append("Error applying topics ").append("delta in ").append(deltaName).toString(), t);
                    }
                    try {
                        this.updateCoordinator(newImage, delta, "__consumer_offsets", (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable)(x$1, x$2) -> $this.groupCoordinator.onElection(x$1, x$2), (Function2<Object, Option<Object>, BoxedUnit>)(Function2 & Serializable)(partitionIndex, leaderEpochOpt) -> {
                            this.groupCoordinator.onResignation(BoxesRunTime.unboxToInt((Object)partitionIndex), this.toOptionalInt((Option<Object>)leaderEpochOpt));
                            return BoxedUnit.UNIT;
                        });
                    }
                    catch (Throwable t) {
                        $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(55).append("Error updating group ").append("coordinator with local changes in ").append(deltaName).toString(), t);
                    }
                    try {
                        this.updateCoordinator(newImage, delta, "__transaction_state", (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable)(txnTopicPartitionId, coordinatorEpoch) -> $this.txnCoordinator.onElection(txnTopicPartitionId, coordinatorEpoch), (Function2<Object, Option<Object>, BoxedUnit>)(Function2 & Serializable)(txnTopicPartitionId, coordinatorEpoch) -> {
                            this.txnCoordinator.onResignation(BoxesRunTime.unboxToInt((Object)txnTopicPartitionId), (Option<Object>)coordinatorEpoch);
                            return BoxedUnit.UNIT;
                        });
                    }
                    catch (Throwable t) {
                        $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(53).append("Error updating txn ").append("coordinator with local changes in ").append(deltaName).toString(), t);
                    }
                    try {
                        ArrayBuffer deletedTopicPartitions = new ArrayBuffer();
                        topicsDelta.deletedTopicIds().forEach(id2 -> {
                            TopicImage topicImage = topicsDelta.image().getTopic(id2);
                            topicImage.partitions().keySet().forEach(id -> deletedTopicPartitions.$plus$eq((Object)new TopicPartition(topicImage.name(), Predef$.MODULE$.Integer2int(id))));
                        });
                        if (!deletedTopicPartitions.nonEmpty()) {
                            return BoxedUnit.UNIT;
                        }
                        $this.groupCoordinator.onPartitionsDeleted(CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)deletedTopicPartitions).asJava(), RequestLocal$.MODULE$.NoCaching().bufferSupplier());
                        runtimeException = BoxedUnit.UNIT;
                    }
                    catch (Throwable t) {
                        runtimeException = $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(60).append("Error updating group ").append("coordinator with deleted partitions in ").append(deltaName).toString(), t);
                    }
                    return runtimeException;
                });
                this.dynamicConfigPublisher().onMetadataUpdate(delta, newImage);
                this.dynamicClientQuotaPublisher.onMetadataUpdate(delta, newImage);
                this.scramPublisher.onMetadataUpdate(delta, newImage);
                this.delegationTokenPublisher.onMetadataUpdate(delta, newImage);
                this.aclPublisher.onMetadataUpdate(delta, newImage, manifest);
                try {
                    this.groupCoordinator.onNewMetadataImage(newImage, delta);
                }
                catch (Throwable t) {
                    this.metadataPublishingFaultHandler.handleFault(new StringBuilder(55).append("Error updating group ").append("coordinator with local changes in ").append(deltaName).toString(), t);
                }
                if (this._firstPublish()) {
                    this.finishInitializingReplicaManager();
                }
            }
            catch (Throwable t) {
                this.metadataPublishingFaultHandler.handleFault(new StringBuilder(57).append("Uncaught exception while ").append("publishing broker metadata from ").append(deltaName).toString(), t);
            }
        }
        finally {
            this._firstPublish_$eq(false);
            this.firstPublishFuture().complete(null);
        }
    }

    private OptionalInt toOptionalInt(Option<Object> option) {
        if (option instanceof Some) {
            return OptionalInt.of(BoxesRunTime.unboxToInt((Object)((Some)option).value()));
        }
        if (None$.MODULE$.equals(option)) {
            return OptionalInt.empty();
        }
        throw new MatchError(option);
    }

    public void reloadUpdatedFilesWithoutConfigChange(Properties props) {
        this.config.dynamicConfig().reloadUpdatedFilesWithoutConfigChange(props);
    }

    public void updateCoordinator(MetadataImage image, MetadataDelta delta, String topicName, Function2<Object, Object, BoxedUnit> election, Function2<Object, Option<Object>, BoxedUnit> resignation) {
        Option$.MODULE$.apply((Object)delta.topicsDelta()).foreach((Function1 & Serializable)topicsDelta -> {
            BrokerMetadataPublisher.$anonfun$updateCoordinator$1(this, topicName, resignation, topicsDelta);
            return BoxedUnit.UNIT;
        });
        BrokerMetadataPublisher$.MODULE$.getTopicDelta(topicName, image, delta).foreach((Function1 & Serializable)topicDelta -> {
            BrokerMetadataPublisher.$anonfun$updateCoordinator$3(this, resignation, election, topicDelta);
            return BoxedUnit.UNIT;
        });
    }

    private void initializeManagers(MetadataImage newImage) {
        try {
            this.logManager.startup(this.metadataCache.getAllTopics());
            this.logManager.deleteStrayKRaftReplicas(this.brokerId(), newImage.topics());
            Option$.MODULE$.apply((Object)this.logManager.cleaner()).foreach((Function1 & Serializable)reconfigurable -> {
                BrokerMetadataPublisher.$anonfun$initializeManagers$1(this, reconfigurable);
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable t) {
            this.fatalFaultHandler.handleFault("Error starting LogManager", t);
        }
        try {
            this.replicaManager.startup();
        }
        catch (Throwable t) {
            this.fatalFaultHandler.handleFault("Error starting ReplicaManager", t);
        }
        try {
            this.groupCoordinator.startup(() -> BoxesRunTime.unboxToInt((Object)$this.metadataCache.numPartitions("__consumer_offsets").getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> Predef$.MODULE$.Integer2int($this.config.offsetsTopicPartitions()))));
        }
        catch (Throwable t) {
            this.fatalFaultHandler.handleFault("Error starting GroupCoordinator", t);
        }
        try {
            this.txnCoordinator.startup((Function0<Object>)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)$this.metadataCache.numPartitions("__transaction_state").getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> Predef$.MODULE$.Integer2int($this.config.transactionTopicPartitions()))), this.txnCoordinator.startup$default$2());
            return;
        }
        catch (Throwable t) {
            this.fatalFaultHandler.handleFault("Error starting TransactionCoordinator", t);
            return;
        }
    }

    private void finishInitializingReplicaManager() {
        try {
            this.replicaManager.startHighWatermarkCheckPointThread();
            return;
        }
        catch (Throwable t) {
            this.metadataPublishingFaultHandler.handleFault("Error starting high watermark checkpoint thread during startup", t);
            return;
        }
    }

    public void close() {
        this.firstPublishFuture().completeExceptionally((Throwable)new TimeoutException());
    }

    public static final /* synthetic */ void $anonfun$onMetadataUpdate$4(BrokerMetadataPublisher $this, OffsetAndEpoch highestOffsetAndEpoch$1, MetadataDelta delta$2, FeaturesDelta featuresDelta) {
        featuresDelta.metadataVersionChange().ifPresent(metadataVersion -> {
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(41).append("Updating metadata.version to ").append(metadataVersion.featureLevel()).append(" at offset ").append(highestOffsetAndEpoch$1).append(".").toString());
            if (delta$2.image().features().metadataVersion().isLessThan(MetadataVersion.IBP_3_7_IV2) && metadataVersion.isAtLeast(MetadataVersion.IBP_3_7_IV2)) {
                $this.info((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(246).append("Resending BrokerRegistration with existing incarnation-id to inform the\n                 |controller about log directories in the broker following metadata update:\n                 |previousMetadataVersion: ").append(delta$2.image().features().metadataVersion()).append("\n                 |newMetadataVersion: ").append(metadataVersion).toString())))).mkString(" ").trim());
                $this.brokerLifecycleManager.handleKraftJBODMetadataVersionUpdate();
                return;
            }
        });
    }

    public static final /* synthetic */ void $anonfun$updateCoordinator$1(BrokerMetadataPublisher $this, String topicName$1, Function2 resignation$1, TopicsDelta topicsDelta) {
        if (topicsDelta.topicWasDeleted(topicName$1)) {
            topicsDelta.image().getTopic(topicName$1).partitions().entrySet().forEach(entry -> {
                if (((PartitionRegistration)entry.getValue()).leader == $this.brokerId()) {
                    resignation$1.apply((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int((Integer)entry.getKey())), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)((PartitionRegistration)entry.getValue()).leaderEpoch)));
                    return;
                }
            });
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$updateCoordinator$3(BrokerMetadataPublisher $this, Function2 resignation$1, Function2 election$1, TopicDelta topicDelta) {
        LocalReplicaChanges changes = topicDelta.localChanges($this.brokerId());
        changes.deletes().forEach(topicPartition -> resignation$1.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()), (Object)None$.MODULE$));
        changes.leaders().forEach((topicPartition, partitionInfo) -> election$1.apply$mcVII$sp(topicPartition.partition(), partitionInfo.partition().leaderEpoch));
        changes.followers().forEach((topicPartition, partitionInfo) -> resignation$1.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)partitionInfo.partition().leaderEpoch))));
    }

    public static final /* synthetic */ void $anonfun$initializeManagers$1(BrokerMetadataPublisher $this, BrokerReconfigurable reconfigurable) {
        $this.config.dynamicConfig().addBrokerReconfigurable(reconfigurable);
    }

    public BrokerMetadataPublisher(KafkaConfig config, KRaftMetadataCache metadataCache, LogManager logManager, ReplicaManager replicaManager, GroupCoordinator groupCoordinator, TransactionCoordinator txnCoordinator, DynamicConfigPublisher dynamicConfigPublisher, DynamicClientQuotaPublisher dynamicClientQuotaPublisher, ScramPublisher scramPublisher, DelegationTokenPublisher delegationTokenPublisher, AclPublisher aclPublisher, FaultHandler fatalFaultHandler, FaultHandler metadataPublishingFaultHandler, BrokerLifecycleManager brokerLifecycleManager) {
        this.config = config;
        this.metadataCache = metadataCache;
        this.logManager = logManager;
        this.replicaManager = replicaManager;
        this.groupCoordinator = groupCoordinator;
        this.txnCoordinator = txnCoordinator;
        this.dynamicConfigPublisher = dynamicConfigPublisher;
        this.dynamicClientQuotaPublisher = dynamicClientQuotaPublisher;
        this.scramPublisher = scramPublisher;
        this.delegationTokenPublisher = delegationTokenPublisher;
        this.aclPublisher = aclPublisher;
        this.fatalFaultHandler = fatalFaultHandler;
        this.metadataPublishingFaultHandler = metadataPublishingFaultHandler;
        this.brokerLifecycleManager = brokerLifecycleManager;
        this.logIdent_$eq(new StringBuilder(30).append("[BrokerMetadataPublisher id=").append(config.nodeId()).append("] ").toString());
        this.brokerId = config.nodeId();
        this._firstPublish = true;
        this.firstPublishFuture = new CompletableFuture();
    }
}

