function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { forwardRef, memo } from 'react';
import classnames from 'classnames';
import { OuiDataGridCell } from './data_grid_cell';
import { OuiText } from '../text';

var DefaultColumnFormatter = function DefaultColumnFormatter(_ref) {
  var children = _ref.children;
  return /*#__PURE__*/React.createElement(OuiText, null, children);
};

var OuiDataGridFooterRow = /*#__PURE__*/memo( /*#__PURE__*/forwardRef(function (_ref2, ref) {
  var leadingControlColumns = _ref2.leadingControlColumns,
      trailingControlColumns = _ref2.trailingControlColumns,
      columns = _ref2.columns,
      schema = _ref2.schema,
      popoverContents = _ref2.popoverContents,
      columnWidths = _ref2.columnWidths,
      defaultColumnWidth = _ref2.defaultColumnWidth,
      className = _ref2.className,
      renderCellValue = _ref2.renderCellValue,
      rowIndex = _ref2.rowIndex,
      interactiveCellId = _ref2.interactiveCellId,
      _dataTestSubj = _ref2['data-test-subj'],
      _ref2$visibleRowIndex = _ref2.visibleRowIndex,
      visibleRowIndex = _ref2$visibleRowIndex === void 0 ? rowIndex : _ref2$visibleRowIndex,
      rest = _objectWithoutProperties(_ref2, ["leadingControlColumns", "trailingControlColumns", "columns", "schema", "popoverContents", "columnWidths", "defaultColumnWidth", "className", "renderCellValue", "rowIndex", "interactiveCellId", "data-test-subj", "visibleRowIndex"]);

  var classes = classnames('ouiDataGridRow', 'ouiDataGridFooter', className);
  var dataTestSubj = classnames('dataGridRow', _dataTestSubj);
  return /*#__PURE__*/React.createElement("div", _extends({
    ref: ref,
    role: "row",
    className: classes,
    "data-test-subj": dataTestSubj
  }, rest), leadingControlColumns.map(function (_ref3, i) {
    var id = _ref3.id,
        width = _ref3.width;
    return /*#__PURE__*/React.createElement(OuiDataGridCell, {
      key: "".concat(id, "-").concat(rowIndex),
      rowIndex: rowIndex,
      visibleRowIndex: visibleRowIndex,
      colIndex: i,
      columnId: id,
      popoverContent: DefaultColumnFormatter,
      width: width,
      renderCellValue: function renderCellValue() {
        return null;
      },
      interactiveCellId: interactiveCellId,
      isExpandable: true,
      className: "ouiDataGridFooterCell ouiDataGridRowCell--controlColumn"
    });
  }), columns.map(function (_ref4, i) {
    var id = _ref4.id;
    var columnType = schema[id] ? schema[id].columnType : null;
    var popoverContent = columnType && popoverContents[columnType] || DefaultColumnFormatter;
    var width = columnWidths[id] || defaultColumnWidth;
    var columnPosition = i + leadingControlColumns.length;
    return /*#__PURE__*/React.createElement(OuiDataGridCell, {
      key: "".concat(id, "-").concat(rowIndex),
      rowIndex: rowIndex,
      visibleRowIndex: visibleRowIndex,
      colIndex: columnPosition,
      columnId: id,
      columnType: columnType,
      popoverContent: popoverContent,
      width: width || undefined,
      renderCellValue: renderCellValue,
      interactiveCellId: interactiveCellId,
      isExpandable: true,
      className: "ouiDataGridFooterCell"
    });
  }), trailingControlColumns.map(function (_ref5, i) {
    var id = _ref5.id,
        width = _ref5.width;
    var colIndex = i + columns.length + leadingControlColumns.length;
    return /*#__PURE__*/React.createElement(OuiDataGridCell, {
      key: "".concat(id, "-").concat(rowIndex),
      rowIndex: rowIndex,
      visibleRowIndex: visibleRowIndex,
      colIndex: colIndex,
      columnId: id,
      popoverContent: DefaultColumnFormatter,
      width: width,
      renderCellValue: function renderCellValue() {
        return null;
      },
      interactiveCellId: interactiveCellId,
      isExpandable: true,
      className: "ouiDataGridFooterCell ouiDataGridRowCell--controlColumn"
    });
  }));
}));
OuiDataGridFooterRow.displayName = 'OuiDataGridFooterRow';
export { OuiDataGridFooterRow };
/* OUI -> EUI Aliases: Build-Time */