"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiHeaderLinks", {
  enumerable: true,
  get: function get() {
    return _header_links.EuiHeaderLinks;
  }
});
exports.OuiHeaderLinks = exports.GUTTER_SIZES = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _common = require("../../common");

var _icon = require("../../icon");

var _popover = require("../../popover");

var _i18n = require("../../i18n");

var _header_section = require("../header_section");

var _responsive = require("../../responsive");

var _header_links = require("../../../eui_components/header/header_links/header_links");

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var gutterSizeToClassNameMap = {
  xs: '--gutterXS',
  s: '--gutterS',
  m: '--gutterM',
  l: '--gutterL'
};
var GUTTER_SIZES = (0, _common.keysOf)(gutterSizeToClassNameMap);
exports.GUTTER_SIZES = GUTTER_SIZES;

var OuiHeaderLinks = function OuiHeaderLinks(_ref) {
  var children = _ref.children,
      className = _ref.className,
      _ref$gutterSize = _ref.gutterSize,
      gutterSize = _ref$gutterSize === void 0 ? 's' : _ref$gutterSize,
      _ref$popoverBreakpoin = _ref.popoverBreakpoints,
      popoverBreakpoints = _ref$popoverBreakpoin === void 0 ? ['xs', 's'] : _ref$popoverBreakpoin,
      popoverButtonProps = _ref.popoverButtonProps,
      popoverProps = _ref.popoverProps,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["children", "className", "gutterSize", "popoverBreakpoints", "popoverButtonProps", "popoverProps"]);

  var _ref2 = popoverButtonProps !== null && popoverButtonProps !== void 0 ? popoverButtonProps : {},
      onClick = _ref2.onClick,
      _ref2$iconType = _ref2.iconType,
      iconType = _ref2$iconType === void 0 ? 'apps' : _ref2$iconType,
      popoverButtonRest = (0, _objectWithoutProperties2.default)(_ref2, ["onClick", "iconType"]);

  var _useState = (0, _react.useState)(false),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      mobileMenuIsOpen = _useState2[0],
      setMobileMenuIsOpen = _useState2[1];

  var onMenuButtonClick = function onMenuButtonClick(e) {
    onClick === null || onClick === void 0 ? void 0 : onClick(e);
    setMobileMenuIsOpen(!mobileMenuIsOpen);
  };

  var closeMenu = function closeMenu() {
    setMobileMenuIsOpen(false);
  };

  (0, _react.useEffect)(function () {
    window.addEventListener('resize', closeMenu);
    return function () {
      window.removeEventListener('resize', closeMenu);
    };
  });
  var classes = (0, _classnames.default)('ouiHeaderLinks', className);

  var button = /*#__PURE__*/_react.default.createElement(_i18n.OuiI18n, {
    token: "ouiHeaderLinks.openNavigationMenu",
    default: "Open menu"
  }, function (openNavigationMenu) {
    return /*#__PURE__*/_react.default.createElement(_header_section.OuiHeaderSectionItemButton, (0, _extends2.default)({
      "aria-label": openNavigationMenu,
      onClick: onMenuButtonClick
    }, popoverButtonRest), /*#__PURE__*/_react.default.createElement(_icon.OuiIcon, {
      type: iconType,
      size: "m"
    }));
  });

  return /*#__PURE__*/_react.default.createElement(_i18n.OuiI18n, {
    token: "ouiHeaderLinks.appNavigation",
    default: "App menu"
  }, function (appNavigation) {
    return /*#__PURE__*/_react.default.createElement("nav", (0, _extends2.default)({
      className: classes,
      "aria-label": appNavigation
    }, rest), /*#__PURE__*/_react.default.createElement(_responsive.OuiHideFor, {
      sizes: popoverBreakpoints
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: (0, _classnames.default)('ouiHeaderLinks__list', ["ouiHeaderLinks__list".concat(gutterSizeToClassNameMap[gutterSize])])
    }, children)), /*#__PURE__*/_react.default.createElement(_responsive.OuiShowFor, {
      sizes: popoverBreakpoints
    }, /*#__PURE__*/_react.default.createElement(_popover.OuiPopover, (0, _extends2.default)({
      button: button,
      isOpen: mobileMenuIsOpen,
      anchorPosition: "downRight",
      closePopover: closeMenu,
      panelPaddingSize: "none"
    }, popoverProps), /*#__PURE__*/_react.default.createElement("div", {
      className: (0, _classnames.default)('ouiHeaderLinks__mobileList', ["ouiHeaderLinks__mobileList".concat(gutterSizeToClassNameMap[gutterSize])])
    }, children))));
  });
};
/* OUI -> EUI Aliases: Build-Time */


exports.OuiHeaderLinks = OuiHeaderLinks;
OuiHeaderLinks.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,

  /**
       * Spacing between direct children
       */
  gutterSize: _propTypes.default.oneOf(["xs", "s", "m", "l"]),

  /**
       * A list of named breakpoints at which to show the popover version
       */
  popoverBreakpoints: _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOf(["xs", "s", "m", "l", "xl"]).isRequired).isRequired, _propTypes.default.oneOf(["all", "none"])]),

  /**
       * Extend the functionality of the OuiPopover.button which is a OuiHeaderSectionItemButton.
       * With the addition of `iconType` to change the display icon which defaults to `apps`
       */
  popoverButtonProps: _propTypes.default.shape({
    iconType: _propTypes.default.oneOfType([_propTypes.default.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "aggregate", "alert", "analyzeEvent", "annotation", "anomalyDetection", "apmApp", "apmTrace", "apps", "appSearchApp", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "asterisk", "auditbeatApp", "beaker", "bell", "bellSlash", "bolt", "boxesHorizontal", "boxesVertical", "branch", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "codeApp", "chatLeft", "chatRight", "check", "checkInCircleEmpty", "checkInCircleFilled", "cheer", "classificationJob", "clock", "cloudDrizzle", "cloudStormy", "cloudSunny", "color", "compute", "console", "consoleApp", "continuityAbove", "continuityAboveBelow", "continuityBelow", "continuityWithin", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crosshairs", "crossInACircleFilled", "crossInCircleEmpty", "crossInCircleFilled", "currency", "cut", "dashboardApp", "database", "dataVisualizer", "devToolsApp", "discoverApp", "document", "documentation", "documentEdit", "documents", "dot", "download", "dockedBottom", "dockedDetached", "dockedLeft", "dockedRight", "dockedTakeover", "dockedTop", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignLeft", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "eql", "eraser", "exit", "expand", "expandMini", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "filebeatApp", "filter", "flag", "fold", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "frameNext", "framePrevious", "fullScreen", "fullScreenExit", "function", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "image", "importAction", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexRuntime", "indexSettings", "inputOutput", "inspect", "integrationGeneral", "integrationObservability", "integrationSearch", "integrationSecurity", "invert", "ip", "keyboardShortcut", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "layers", "lensApp", "link", "list", "listAdd", "lock", "lockOpen", "logsApp", "logoAerospike", "logoApache", "logoAppSearch", "logoAWS", "logoAWSMono", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticsearch", "logoElasticStack", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOpenSearch", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuDown", "menuLeft", "menuRight", "menuUp", "merge", "metricbeatApp", "metricsApp", "minimize", "minus", "minusInCircle", "minusInCircleFilled", "mobile", "monitoringApp", "moon", "nested", "node", "notebookApp", "number", "offline", "online", "outlierDetectionJob", "package", "packetbeatApp", "pageSelect", "pagesSelect", "partial", "paperClip", "pause", "pencil", "percent", "pin", "pinFilled", "pipelineApp", "play", "playFilled", "plus", "plusInCircle", "plusInCircleFilled", "polygon", "popout", "power", "push", "questionInCircle", "quote", "radius", "recentlyViewedApp", "redeploy", "refresh", "regressionJob", "reporter", "reportingApp", "returnKey", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "shard", "share", "snowflake", "sortable", "sortDown", "sortLeft", "sortRight", "sortUp", "spacesApp", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "swatchInput", "symlink", "tableOfContents", "tableDensityExpanded", "tableDensityCompact", "tableDensityNormal", "tag", "tear", "temperature", "thumbsDown", "thumbsUp", "timeline", "timelionApp", "timeslider", "training", "trash", "upgradeAssistantApp", "uptimeApp", "undeploy", "unfold", "unlink", "user", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visBuilder", "visBuilderSavedObject", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visQueryDQL", "visQueryPPL", "visQueryPromQL", "visQuerySQL", "visTable", "visTagCloud", "visText", "visTimelion", "visualizeApp", "visVega", "visVisualBuilder", "watchesApp", "wordWrap", "wordWrapDisabled", "workplaceSearchApp", "wrench", "tokenClass", "tokenProperty", "tokenEnum", "tokenVariable", "tokenMethod", "tokenAnnotation", "tokenException", "tokenInterface", "tokenParameter", "tokenField", "tokenElement", "tokenFunction", "tokenBoolean", "tokenString", "tokenArray", "tokenNumber", "tokenConstant", "tokenObject", "tokenEvent", "tokenKey", "tokenNull", "tokenStruct", "tokenPackage", "tokenOperator", "tokenEnumMember", "tokenRepo", "tokenSymbol", "tokenFile", "tokenModule", "tokenNamespace", "tokenDate", "tokenIP", "tokenNested", "tokenAlias", "tokenShape", "tokenGeo", "tokenRange", "tokenBinary", "tokenJoin", "tokenPercolator", "tokenFlattened", "tokenRankFeature", "tokenRankFeatures", "tokenKeyword", "tokenCompletionSuggester", "tokenDenseVector", "tokenText", "tokenTokenCount", "tokenSearchType", "tokenHistogram"]).isRequired, _propTypes.default.string.isRequired, _propTypes.default.elementType.isRequired])
  }),

  /**
       * Extend the functionality of the OuiPopover
       */
  popoverProps: _propTypes.default.shape({
    /**
       * Class name passed to the direct parent of the button
       */
    anchorClassName: _propTypes.default.string,

    /**
       * Alignment of the popover and arrow relative to the button
       */
    anchorPosition: _propTypes.default.oneOf(["upCenter", "upLeft", "upRight", "downCenter", "downLeft", "downRight", "leftCenter", "leftUp", "leftDown", "rightCenter", "rightUp", "rightDown"]),

    /**
       * Style and position alteration for arrow-less, left-aligned
       * attachment. Intended for use with inputs as anchors, e.g.
       * OuiInputPopover
       */
    attachToAnchor: _propTypes.default.bool,
    buttonRef: _propTypes.default.any,

    /**
       * Restrict the popover's position within this element
       */
    container: _propTypes.default.any,

    /**
       * CSS display type for both the popover and anchor
       */
    display: _propTypes.default.oneOf(["inlineBlock", "block"]),

    /**
       * Object of props passed to OuiFocusTrap
       */
    focusTrapProps: _propTypes.default.any,

    /**
       * Show arrow indicating to originating button
       */
    hasArrow: _propTypes.default.bool,

    /**
       * Specifies what element should initially have focus; Can be a DOM
       * node, or a selector string (which will be passed to
       * document.querySelector() to find the DOM node), or a function that
       * returns a DOM node
       * Set to `false` to prevent initial auto-focus. Use only
       * when your app handles setting initial focus state.
       */
    initialFocus: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.string.isRequired, _propTypes.default.func.isRequired]).isRequired, _propTypes.default.oneOf([false])]),

    /**
       * Passed directly to OuiPortal for DOM positioning. Both properties are
       * required if prop is specified
       */
    insert: _propTypes.default.shape({
      sibling: _propTypes.default.any.isRequired,
      position: _propTypes.default.oneOf(["before", "after"]).isRequired
    }),

    /**
       * Visibility state of the popover
       */
    isOpen: _propTypes.default.bool,

    /**
       * Traps tab focus within the popover contents
       */
    ownFocus: _propTypes.default.bool,

    /**
       * Custom class added to the OuiPanel containing the popover contents
       */
    panelClassName: _propTypes.default.string,

    /**
       * OuiPanel padding on all sides
       */
    panelPaddingSize: _propTypes.default.any,

    /**
       * Standard DOM `style` attribute. Passed to the OuiPanel
       */
    panelStyle: _propTypes.default.any,

    /**
       * Object of props passed to OuiPanel
       */
    panelProps: _propTypes.default.any,
    panelRef: _propTypes.default.any,
    popoverRef: _propTypes.default.any,

    /**
       * When `true`, the popover's position is re-calculated when the user
       * scrolls, this supports having fixed-position popover anchors
       */
    repositionOnScroll: _propTypes.default.bool,

    /**
       * By default, popover content inherits the z-index of the anchor
       * component; pass `zIndex` to override
       */
    zIndex: _propTypes.default.number,

    /**
       * Function callback for when the focus trap is deactivated
       */
    onTrapDeactivation: _propTypes.default.any,

    /**
       * Distance away from the anchor that the popover will render
       */
    offset: _propTypes.default.number,

    /**
       * Minimum distance between the popover and the bounding container;
       * Pass an array of 4 values to adjust each side differently: `[top, right, bottom, left]`
       * Default is 16
       */
    buffer: _propTypes.default.oneOfType([_propTypes.default.number.isRequired, _propTypes.default.any.isRequired]),

    /**
       * Element to pass as the child element of the arrow;
       * Use case is typically limited to an accompanying `OuiBeacon`
       */
    arrowChildren: _propTypes.default.node,

    /**
       * Provide a name to the popover panel
       */
    "aria-label": _propTypes.default.string,

    /**
       * Alternative option to `aria-label` that takes an `id`.
       * Usually takes the `id` of the popover title
       */
    "aria-labelledby": _propTypes.default.string
  })
};
/* OUI -> EUI Aliases: Build-Time */