"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateDataSourceNameInVegaSpec = exports.getDataSourceTitleFromId = exports.extractVegaSpecFromSavedObject = void 0;
var _hjson = require("hjson");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const updateDataSourceNameInVegaSpec = props => {
  const {
    spec
  } = props;
  let parsedSpec = parseJSONSpec(spec);
  const isJSONString = !!parsedSpec;
  if (!parsedSpec) {
    parsedSpec = (0, _hjson.parse)(spec, {
      keepWsc: true
    });
  }
  const dataField = parsedSpec.data;
  if (dataField instanceof Array) {
    parsedSpec.data = dataField.map(dataObject => {
      return updateDataSourceNameForDataObject(dataObject, props);
    });
  } else if (dataField instanceof Object) {
    parsedSpec.data = updateDataSourceNameForDataObject(dataField, props);
  } else {
    throw new Error(`"data" field should be an object or an array of objects`);
  }
  return isJSONString ? JSON.stringify(parsedSpec) : (0, _hjson.stringify)(parsedSpec, {
    bracesSameLine: true,
    keepWsc: true
  });
};
exports.updateDataSourceNameInVegaSpec = updateDataSourceNameInVegaSpec;
const getDataSourceTitleFromId = async (dataSourceId, savedObjectsClient) => {
  return await savedObjectsClient.get('data-source', dataSourceId).then(response => {
    var _response$attributes$, _response$attributes;
    // @ts-expect-error
    return (_response$attributes$ = response === null || response === void 0 || (_response$attributes = response.attributes) === null || _response$attributes === void 0 ? void 0 : _response$attributes.title) !== null && _response$attributes$ !== void 0 ? _response$attributes$ : undefined;
  });
};
exports.getDataSourceTitleFromId = getDataSourceTitleFromId;
const extractVegaSpecFromSavedObject = savedObject => {
  if (isVegaVisualization(savedObject)) {
    var _savedObject$attribut;
    // @ts-expect-error
    const visStateObject = JSON.parse((_savedObject$attribut = savedObject.attributes) === null || _savedObject$attribut === void 0 ? void 0 : _savedObject$attribut.visState);
    return visStateObject.params.spec;
  }
  return undefined;
};
exports.extractVegaSpecFromSavedObject = extractVegaSpecFromSavedObject;
const isVegaVisualization = savedObject => {
  var _savedObject$attribut2;
  // @ts-expect-error
  const visState = (_savedObject$attribut2 = savedObject.attributes) === null || _savedObject$attribut2 === void 0 ? void 0 : _savedObject$attribut2.visState;
  if (!!visState) {
    const visStateObject = JSON.parse(visState);
    return !!visStateObject.type && visStateObject.type === 'vega';
  }
  return false;
};
const updateDataSourceNameForDataObject = (dataObject, props) => {
  const {
    newDataSourceName
  } = props;
  if (dataObject.hasOwnProperty('url') && dataObject.url.hasOwnProperty('index') && !dataObject.url.hasOwnProperty('data_source_name')) {
    dataObject.url.data_source_name = newDataSourceName;
  }
  return dataObject;
};
const parseJSONSpec = spec => {
  try {
    const jsonSpec = JSON.parse(spec);
    if (jsonSpec && typeof jsonSpec === 'object') {
      return jsonSpec;
    }
  } catch (e) {
    return undefined;
  }
  return undefined;
};