"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.decideClient = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const decideClient = async (context, request, withLongNumeralsSupport = false) => {
  const defaultOpenSearchClient = withLongNumeralsSupport ? context.core.opensearch.client.asCurrentUserWithLongNumeralsSupport : context.core.opensearch.client.asCurrentUser;
  return request.dataSourceId && context.dataSource ? await context.dataSource.opensearch.getClient(request.dataSourceId) : defaultOpenSearchClient;
};
exports.decideClient = decideClient;