"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.web = exports.getAvailebleEnvironments = exports.setEnvironment = exports.linuxDesktop = exports.platform = exports.app = exports.ServerType = void 0;
const minimist_1 = __importDefault(require("minimist"));
const config_1 = require("../settings/config");
const ConfigurationPersistence_1 = require("../settings/ConfigurationPersistence");
const SettingsType_1 = require("../settings/SettingsType");
const argv = (0, minimist_1.default)(process.argv.slice(1));
const webappUrlSetting = ConfigurationPersistence_1.settings.restore(SettingsType_1.SettingsType.CUSTOM_WEBAPP_URL);
const customWebappUrl = argv[config_1.config.ARGUMENT.ENV] || webappUrlSetting;
const isProdEnvironment = !!customWebappUrl;
var ServerType;
(function (ServerType) {
    ServerType["PRODUCTION"] = "PRODUCTION";
    ServerType["EDGE"] = "EDGE";
    ServerType["BETA"] = "INTERNAL";
})(ServerType || (exports.ServerType = ServerType = {}));
let currentEnvironment = ConfigurationPersistence_1.settings.restore(SettingsType_1.SettingsType.ENV);
const URL_WEBSITE = {
    PRODUCTION: config_1.config.websiteUrl,
    STAGING: 'https://wire-website-staging.zinfra.io',
};
const webappEnvironments = {
    [ServerType.PRODUCTION]: { name: 'Production', server: ServerType.PRODUCTION, url: 'https://app.wire.com' },
    [ServerType.BETA]: { name: 'Beta', server: ServerType.BETA, url: 'https://wire-webapp-staging.wire.com' },
    [ServerType.EDGE]: { name: 'Edge', server: ServerType.EDGE, url: 'https://wire-webapp-edge.wire.com' },
};
exports.app = {
    ENV: config_1.config.environment,
    IS_DEVELOPMENT: config_1.config.environment !== 'production',
    IS_PRODUCTION: config_1.config.environment === 'production',
    UPDATE_URL_WIN: config_1.config.updateUrl,
};
const isEnvVar = (envVar, value, caseSensitive = false) => {
    let envVarContent = process.env[envVar] || '';
    if (!caseSensitive) {
        envVar = envVar.toLowerCase();
        envVarContent = envVarContent.toLowerCase();
    }
    return envVarContent.includes(value);
};
exports.platform = {
    IS_LINUX: process.platform === 'linux',
    IS_MAC_OS: process.platform === 'darwin',
    IS_WINDOWS: process.platform === 'win32',
};
exports.linuxDesktop = {
    isGnomeX11: isEnvVar('XDG_CURRENT_DESKTOP', 'gnome') && isEnvVar('XDG_SESSION_TYPE', 'x11'),
    isPopOS: isEnvVar('XDG_CURRENT_DESKTOP', 'pop'),
    isUbuntuUnity: isEnvVar('XDG_CURRENT_DESKTOP', 'Unity'),
};
const setEnvironment = (env) => {
    currentEnvironment = env;
    ConfigurationPersistence_1.settings.save(SettingsType_1.SettingsType.ENV, env);
    ConfigurationPersistence_1.settings.persistToFile();
};
exports.setEnvironment = setEnvironment;
function getWebappUrl() {
    var _a, _b;
    const envUrl = currentEnvironment && ((_a = webappEnvironments[currentEnvironment]) === null || _a === void 0 ? void 0 : _a.url);
    return (_b = customWebappUrl !== null && customWebappUrl !== void 0 ? customWebappUrl : envUrl) !== null && _b !== void 0 ? _b : config_1.config.appBase;
}
function getAvailebleEnvironments() {
    const customEnv = customWebappUrl
        ? {
            name: customWebappUrl.replace(/^https?:\/\//, ''),
            url: customWebappUrl,
            isActive: true,
        }
        : null;
    const baseEnvs = Object.values(webappEnvironments).map(({ name, server, url }) => {
        return {
            name,
            server,
            url,
            isActive: url === getWebappUrl(),
        };
    });
    return customEnv ? [customEnv, ...baseEnvs] : baseEnvs;
}
exports.getAvailebleEnvironments = getAvailebleEnvironments;
exports.web = {
    getWebappUrl,
    getWebsiteUrl: (path = '') => {
        const baseUrl = isProdEnvironment ? URL_WEBSITE.PRODUCTION : URL_WEBSITE.STAGING;
        return `${baseUrl}${path}`;
    },
};
//# sourceMappingURL=EnvironmentUtil.js.map