"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProxyPromptWindow = void 0;
const electron_1 = require("electron");
const path = __importStar(require("path"));
const url_1 = require("url");
const eventType_1 = require("../lib/eventType");
const locale = __importStar(require("../locale"));
const config_1 = require("../settings/config");
const appPath = path.join(electron_1.app.getAppPath(), config_1.config.electronDirectory);
const promptHtmlPath = (0, url_1.pathToFileURL)(path.join(appPath, 'html/proxy-prompt.html')).href;
const proxyPromptWindowAllowList = [promptHtmlPath, (0, url_1.pathToFileURL)(path.join(appPath, 'css/proxy-prompt.css'))];
const preloadPath = path.join(appPath, 'dist/preload/menu/preload-proxy-prompt.js');
const windowSize = {
    HEIGHT: 350,
    WIDTH: 550,
};
const showWindow = () => __awaiter(void 0, void 0, void 0, function* () {
    let proxyPromptWindow;
    if (!proxyPromptWindow) {
        proxyPromptWindow = new electron_1.BrowserWindow({
            alwaysOnTop: true,
            backgroundColor: '#ececec',
            fullscreen: false,
            height: windowSize.HEIGHT,
            maximizable: false,
            minimizable: false,
            resizable: false,
            show: false,
            title: config_1.config.name,
            webPreferences: {
                javascript: true,
                nodeIntegration: false,
                nodeIntegrationInWorker: false,
                preload: preloadPath,
                sandbox: false,
                session: electron_1.session.fromPartition('proxy-prompt-window'),
                spellcheck: false,
                webviewTag: false,
            },
            width: windowSize.WIDTH,
        });
        proxyPromptWindow.setMenuBarVisibility(false);
        proxyPromptWindow.webContents.session.webRequest.onBeforeRequest((_a, callback_1) => __awaiter(void 0, [_a, callback_1], void 0, function* ({ url }, callback) {
            if (proxyPromptWindowAllowList.includes(url)) {
                return callback({ cancel: false });
            }
            callback({ redirectURL: promptHtmlPath });
        }));
        electron_1.ipcMain.on(eventType_1.EVENT_TYPE.PROXY_PROMPT.LOCALE_VALUES, (event, labels) => {
            if (proxyPromptWindow) {
                const isExpected = event.sender.id === proxyPromptWindow.webContents.id;
                if (isExpected) {
                    const resultLabels = {};
                    labels.forEach(label => (resultLabels[label] = locale.getText(label)));
                    event.reply(eventType_1.EVENT_TYPE.PROXY_PROMPT.LOCALE_RENDER, resultLabels);
                }
            }
        });
        proxyPromptWindow.on('closed', () => (proxyPromptWindow = undefined));
        yield proxyPromptWindow.loadURL(promptHtmlPath);
        if (proxyPromptWindow) {
            proxyPromptWindow.webContents.send(eventType_1.EVENT_TYPE.PROXY_PROMPT.LOADED);
        }
    }
    proxyPromptWindow.show();
});
exports.ProxyPromptWindow = { showWindow };
//# sourceMappingURL=ProxyPromptWindow.js.map