"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.openExternal = exports.isInView = exports.pointInRectangle = void 0;
const electron_1 = require("electron");
const path = __importStar(require("path"));
const url_1 = require("url");
const showDialog_1 = require("../lib/showDialog");
const locale = __importStar(require("../locale"));
const getLogger_1 = require("../logging/getLogger");
const config_1 = require("../settings/config");
const logger = (0, getLogger_1.getLogger)(path.basename(__filename));
const pointInRectangle = (point, rectangle) => {
    const [xCoordinate, yCoordinate] = point;
    const xInRange = xCoordinate >= rectangle.x && xCoordinate <= rectangle.x + rectangle.width;
    const yInRange = yCoordinate >= rectangle.y && yCoordinate <= rectangle.y + rectangle.height;
    return xInRange && yInRange;
};
exports.pointInRectangle = pointInRectangle;
const isInView = (win) => {
    const windowBounds = win.getBounds();
    const nearestWorkArea = electron_1.screen.getDisplayMatching(windowBounds).workArea;
    const upperLeftVisible = (0, exports.pointInRectangle)([windowBounds.x, windowBounds.y], nearestWorkArea);
    const lowerRightVisible = (0, exports.pointInRectangle)([windowBounds.x + windowBounds.width, windowBounds.y + windowBounds.height], nearestWorkArea);
    return upperLeftVisible || lowerRightVisible;
};
exports.isInView = isInView;
const openExternal = (url_2, ...args_1) => __awaiter(void 0, [url_2, ...args_1], void 0, function* (url, httpsOnly = false) {
    try {
        const urlProtocol = new url_1.URL(url).protocol || '';
        const allowedProtocols = ['https:'];
        if (!httpsOnly) {
            allowedProtocols.push('ftp:', 'http:', 'mailto:', `${config_1.config.customProtocolName}:`);
        }
        if (!allowedProtocols.includes(urlProtocol)) {
            logger.warn(`Prevented opening external URL "${url}".`);
            const dialogText = `${locale.getText('urlBlockedPromptText')}\n\n${url}`;
            (0, showDialog_1.showWarningDialog)(dialogText);
            return;
        }
        yield electron_1.shell.openExternal(url);
    }
    catch (error) {
        logger.error(error);
    }
});
exports.openExternal = openExternal;
//# sourceMappingURL=WindowUtil.js.map