"use strict";
/*
 * Wire
 * Copyright (C) 2018 Wire Swiss GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses/.
 *
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.bytesToUUID = exports.uuidToBytes = exports.pluralize = exports.capitalize = void 0;
function capitalize(text) {
    return text.charAt(0).toUpperCase() + text.slice(1);
}
exports.capitalize = capitalize;
function pluralize(text, times, options) {
    const postfix = (options === null || options === void 0 ? void 0 : options.postfix) || 's';
    return `${text}${times === 1 ? '' : postfix}`;
}
exports.pluralize = pluralize;
function uuidToBytes(uuid) {
    return Buffer.from(uuid.replace(/-/g, ''), 'hex');
}
exports.uuidToBytes = uuidToBytes;
function bytesToUUID(uuid) {
    const str = uuid.toString('hex');
    return `${str.slice(0, 8)}-${str.slice(8, 12)}-${str.slice(12, 16)}-${str.slice(16, 20)}-${str.slice(20)}`;
}
exports.bytesToUUID = bytesToUUID;
