"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.filterButtonProps = exports.Button = exports.buttonStyle = exports.ButtonVariant = void 0;
const jsx_runtime_1 = require("@emotion/react/jsx-runtime");
const Identity_1 = require("../Identity");
const motions_1 = require("../Identity/motions");
const Misc_1 = require("../Misc");
const Text_1 = require("../Text");
const util_1 = require("../util");
var ButtonVariant;
(function (ButtonVariant) {
    ButtonVariant["PRIMARY"] = "primary";
    ButtonVariant["SECONDARY"] = "secondary";
    ButtonVariant["TERTIARY"] = "tertiary";
    ButtonVariant["QUATERNARY"] = "quaternary";
    ButtonVariant["SEND"] = "send";
    ButtonVariant["CANCEL"] = "cancel";
})(ButtonVariant || (exports.ButtonVariant = ButtonVariant = {}));
const buttonStyle = (theme, _a) => {
    var { variant = ButtonVariant.PRIMARY, backgroundColor, block = false, disabled = false, noCapital = false, bold = true, center = true, color = Identity_1.COLOR.WHITE, fontSize = theme.fontSizes.base, noWrap = true, textTransform = 'none', truncate = true } = _a, props = __rest(_a, ["variant", "backgroundColor", "block", "disabled", "noCapital", "bold", "center", "color", "fontSize", "noWrap", "textTransform", "truncate"]);
    return (Object.assign(Object.assign(Object.assign(Object.assign(Object.assign(Object.assign(Object.assign(Object.assign(Object.assign({}, (0, Text_1.textStyle)(theme, Object.assign({ block,
        bold,
        center,
        disabled,
        fontSize,
        noWrap,
        textTransform,
        truncate }, props))), { border: 0, cursor: disabled ? 'default' : 'pointer', display: 'flex', alignItems: 'center', justifyContent: 'center', marginBottom: '16px', padding: 0, outline: 'none', textDecoration: 'none', touchAction: 'manipulation', transition: motions_1.defaultTransition, width: block ? '100%' : 'auto', '&:hover, &:focus': {
            textDecoration: 'none',
        } }), (variant !== ButtonVariant.TERTIARY && Object.assign({ borderRadius: variant === ButtonVariant.SEND ? '100%' : '16px', height: variant === ButtonVariant.SEND ? '40px' : '48px', lineHeight: variant === ButtonVariant.SEND ? '40px' : '48px' }, (variant !== ButtonVariant.SEND && {
        maxWidth: '100%',
        minWidth: '125px',
        padding: '0 16px',
    })))), (variant === ButtonVariant.PRIMARY && Object.assign({ backgroundColor: backgroundColor || (disabled ? theme.Button.primaryDisabledBg : theme.Button.primaryBg), color: disabled ? theme.Button.primaryDisabledText : theme.general.contrastColor }, (!disabled && {
        '&:hover, &:focus': {
            backgroundColor: theme.Button.primaryHoverBg,
        },
        '&:focus': {
            border: `1px solid ${theme.Button.primaryFocusBorder}`,
        },
        '&:active': {
            backgroundColor: theme.Button.primaryActiveBg,
            border: `1px solid ${theme.Button.primaryActiveBorder}`,
            color: Identity_1.COLOR.WHITE,
        },
    })))), (variant === ButtonVariant.SECONDARY && Object.assign({ backgroundColor: backgroundColor || (disabled ? theme.IconButton.primaryDisabledBgColor : theme.IconButton.primaryBgColor), border: `1px solid ${theme.IconButton.primaryBorderColor}`, color: disabled ? theme.Input.placeholderColor : theme.general.color }, (!disabled && {
        '&:hover, &:focus': {
            border: `1px solid ${theme.Button.secondaryHoverBorder}`,
        },
        '&:focus': {
            color: theme.IconButton.primaryActiveFillColor,
        },
        '&:active': {
            backgroundColor: theme.Button.secondaryActiveBg,
            border: `1px solid ${theme.Button.secondaryActiveBorder}`,
            color: theme.general.primaryColor,
        },
    })))), (variant === ButtonVariant.TERTIARY && Object.assign({ backgroundColor: backgroundColor || (disabled ? theme.Button.tertiarydisabledBg : theme.Button.tertiaryBg), border: disabled ? `1px solid ${theme.Button.tertiaryDisabledBorder}` : `1px solid ${theme.Button.tertiaryBorder}`, borderRadius: '12px', color: disabled ? theme.Input.placeholderColor : theme.general.color, fontSize: theme.fontSizes.medium, fontWeight: 700, lineHeight: '1.5rem', padding: '4px 8px', '& > svg > path': {
            fill: disabled ? theme.Input.placeholderColor : theme.general.color,
        } }, (!disabled && {
        '&:hover, &:focus': {
            backgroundColor: theme.Button.tertiaryHoverBg,
            border: `1px solid ${theme.Button.tertiaryHoverBorder}`,
        },
        '&:focus': {
            border: `1px solid ${theme.general.focusColor}`,
        },
        '&:active': {
            backgroundColor: theme.Button.tertiaryActiveBg,
            color: theme.IconButton.primaryActiveFillColor,
            '& > svg > path': {
                fill: theme.IconButton.primaryActiveFillColor,
            },
        },
    })))), (variant === ButtonVariant.QUATERNARY && Object.assign({ backgroundColor: backgroundColor || (disabled ? Identity_1.COLOR_V2.GRAY_50 : Identity_1.COLOR_V2.GREEN), color: disabled ? Identity_1.COLOR_V2.GRAY_80 : Identity_1.COLOR_V2.WHITE, lineHeight: '1.5rem' }, (!disabled && {
        '&:hover, &:focus': {
            backgroundColor: Identity_1.COLOR_V2.GREEN_LIGHT_600,
        },
        '&:focus': {
            border: `1px solid ${Identity_1.COLOR_V2.GREEN_LIGHT_700}`,
        },
        '&:active': {
            backgroundColor: Identity_1.COLOR_V2.GREEN_LIGHT_700,
        },
    })))), (variant === ButtonVariant.CANCEL && Object.assign({ backgroundColor: backgroundColor || (disabled ? Identity_1.COLOR_V2.GRAY_50 : Identity_1.COLOR_V2.RED), color: disabled ? Identity_1.COLOR_V2.GRAY_80 : Identity_1.COLOR_V2.WHITE, lineHeight: '1.5rem' }, (!disabled && {
        '&:hover, &:focus': {
            backgroundColor: Identity_1.COLOR_V2.RED_LIGHT_600,
        },
        '&:focus': {
            border: `1px solid ${Identity_1.COLOR_V2.RED_LIGHT_700}`,
        },
        '&:active': {
            backgroundColor: Identity_1.COLOR_V2.RED_LIGHT_700,
        },
    })))), (variant === ButtonVariant.SEND && Object.assign({ backgroundColor: backgroundColor || (disabled ? Identity_1.COLOR_V2.GRAY_70 : Identity_1.COLOR_V2.BLUE), width: '40px' }, (!disabled && {
        '&:hover, &:focus': {
            backgroundColor: Identity_1.COLOR_V2.BLUE_LIGHT_600,
        },
        '&:focus': {
            border: `1px solid ${Identity_1.COLOR_V2.BLUE_LIGHT_800}`,
        },
        '&:active': {
            backgroundColor: Identity_1.COLOR_V2.BLUE_LIGHT_700,
        },
    })))));
};
exports.buttonStyle = buttonStyle;
const Button = (_a) => {
    var { showLoading, children, loadingColor = Identity_1.COLOR.WHITE } = _a, props = __rest(_a, ["showLoading", "children", "loadingColor"]);
    return ((0, jsx_runtime_1.jsx)("button", Object.assign({ css: (theme) => (0, exports.buttonStyle)(theme, props) }, (0, exports.filterButtonProps)(props), { children: showLoading ? (0, jsx_runtime_1.jsx)(Misc_1.Loading, { size: 30, color: loadingColor, style: { display: 'flex', margin: 'auto' } }) : children })));
};
exports.Button = Button;
const filterButtonProps = (props) => {
    return (0, util_1.filterProps)((0, Text_1.filterTextProps)(props), ['backgroundColor', 'noCapital']);
};
exports.filterButtonProps = filterButtonProps;
