"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ErrorMessage = exports.filterErrorMessageProps = exports.errorMessageStyle = void 0;
const jsx_runtime_1 = require("@emotion/react/jsx-runtime");
const Identity_1 = require("../Identity");
const Layout_1 = require("../Layout");
const Text_1 = require("../Text");
const util_1 = require("../util");
const errorMessageStyle = (theme, _a) => {
    var { justify = 'flex-start', align = 'center' } = _a, props = __rest(_a, ["justify", "align"]);
    return (Object.assign(Object.assign({}, (0, Layout_1.flexBoxStyle)(Object.assign({ align, justify }, props))), { a: Object.assign({}, (0, Text_1.linkStyle)(theme, Object.assign({ bold: false, fontSize: theme.fontSizes.small, textTransform: 'none' }, props))), marginBottom: '12px' }));
};
exports.errorMessageStyle = errorMessageStyle;
const filterErrorMessageProps = (props) => {
    return (0, util_1.filterProps)((0, Layout_1.filterFlexBoxProps)(props), []);
};
exports.filterErrorMessageProps = filterErrorMessageProps;
const ErrorMessage = (_a) => {
    var { children } = _a, props = __rest(_a, ["children"]);
    return ((0, jsx_runtime_1.jsx)(Layout_1.FlexBox, Object.assign({ css: (theme) => (0, exports.errorMessageStyle)(theme, props) }, props, { children: (0, jsx_runtime_1.jsx)(Text_1.Text, { color: Identity_1.COLOR_V2.RED_LIGHT_500, fontSize: '12px', css: { fontWeight: 400 }, children: children }) })));
};
exports.ErrorMessage = ErrorMessage;
