"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.IndicatorRangeInput = void 0;
const jsx_runtime_1 = require("@emotion/react/jsx-runtime");
/*
 * Wire
 * Copyright (C) 2022 Wire Swiss GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses/.
 *
 */
const react_1 = require("react");
const IndicatorRangeInput_styles_1 = require("./IndicatorRangeInput.styles");
const InputLabel_1 = require("./InputLabel");
exports.IndicatorRangeInput = (0, react_1.forwardRef)((_a, ref) => {
    var _b;
    var { id = Math.random().toString(), label, min = '0', max = '100', value = '0', onChange, onOptionClick, wrapperCSS, dataListOptions = [] } = _a, inputProps = __rest(_a, ["id", "label", "min", "max", "value", "onChange", "onOptionClick", "wrapperCSS", "dataListOptions"]);
    const minNum = Number(min);
    const isCustomSlider = !!dataListOptions.length;
    const listLength = dataListOptions.length - 1;
    const valueNum = Number(value);
    const maxNum = isCustomSlider ? Number(listLength) : Number(max);
    const backgroundSize = (0, react_1.useMemo)(() => {
        if (isCustomSlider && valueNum === 0) {
            const firstOptionThumbPosition = `calc(((100% - 10px) / (${listLength} * 2) - 4px) / 2)`;
            return `${firstOptionThumbPosition} 100%`;
        }
        return `${((valueNum - minNum) * 100) / (maxNum - minNum)}% 100%`;
    }, [isCustomSlider, valueNum, minNum, maxNum, listLength]);
    const valueText = ((_b = dataListOptions[valueNum]) === null || _b === void 0 ? void 0 : _b.heading)
        ? `${dataListOptions[valueNum].label} (${dataListOptions[valueNum].heading})`
        : dataListOptions[valueNum].label;
    return ((0, jsx_runtime_1.jsxs)("div", { css: { wrapperCSS, width: '100%' }, children: [label && ((0, jsx_runtime_1.jsx)(InputLabel_1.InputLabel, { css: (theme) => ({ fontSize: theme.fontSizes.base }), htmlFor: id, children: label })), (0, jsx_runtime_1.jsxs)("div", { css: IndicatorRangeInput_styles_1.containerStyles, children: [isCustomSlider && ((0, jsx_runtime_1.jsx)("div", { css: { position: 'relative', display: 'flex', marginBottom: '20px' }, children: dataListOptions.map((dataListOption, index) => ((0, jsx_runtime_1.jsx)("div", { css: (theme) => (0, IndicatorRangeInput_styles_1.headingStyle)(listLength, theme), onClick: () => {
                                if (dataListOption === null || dataListOption === void 0 ? void 0 : dataListOption.heading) {
                                    onOptionClick(index);
                                }
                            }, children: dataListOption === null || dataListOption === void 0 ? void 0 : dataListOption.heading }, dataListOption.value))) })), (0, jsx_runtime_1.jsx)("input", Object.assign({ ref: ref, css: (theme) => (0, IndicatorRangeInput_styles_1.rangeStyles)(backgroundSize, valueNum, listLength, isCustomSlider, theme), id: id, name: id, min: minNum, max: maxNum, value: value, onChange: onChange, type: "range", list: "tickMarks" }, (isCustomSlider && {
                        'aria-valuetext': valueText,
                    }), inputProps)), isCustomSlider && ((0, jsx_runtime_1.jsx)("datalist", { id: "tickMarks", css: (theme) => (0, IndicatorRangeInput_styles_1.dataListOption)(listLength, theme), children: dataListOptions.map((dataListOption, index) => ((0, jsx_runtime_1.jsx)("option", { value: dataListOption.value, label: dataListOption.label, onClick: () => onOptionClick(index) }, index))) }))] })] }));
});
exports.IndicatorRangeInput.displayName = 'IndicatorRangeInput';
