"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Input = exports.INPUT_GROUP = exports.INPUT_CLASSNAME = exports.inputStyle = void 0;
const jsx_runtime_1 = require("@emotion/react/jsx-runtime");
/*
 * Wire
 * Copyright (C) 2018 Wire Swiss GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses/.
 *
 */
const react_1 = require("react");
const React = __importStar(require("react"));
const InputLabel_1 = require("./InputLabel");
const Icon_1 = require("../Icon");
const util_1 = require("../util");
const inputStyle = (theme, { markInvalid = false, placeholderTextTransform = 'none', disabled = false }) => {
    const placeholderStyle = {
        color: theme.Input.placeholderColor,
        fontSize: theme.fontSizes.base,
        textTransform: placeholderTextTransform,
    };
    return {
        '&::-moz-placeholder': Object.assign(Object.assign({}, placeholderStyle), { opacity: 1 }),
        '&::-ms-input-placeholder': Object.assign({}, placeholderStyle),
        '&::-webkit-input-placeholder': Object.assign({}, placeholderStyle),
        '&:hover': {
            boxShadow: !disabled && `0 0 0 1px ${theme.Input.borderHover}`,
        },
        '&:focus-visible, &:focus, &:active': {
            boxShadow: `0 0 0 1px ${theme.general.primaryColor}`,
        },
        '&:invalid:not(:focus, :hover)': !markInvalid
            ? {
                boxShadow: `0 0 0 1px ${theme.Select.borderColor}`,
            }
            : {},
        background: disabled ? theme.Input.backgroundColorDisabled : theme.Input.backgroundColor,
        border: 'none',
        borderRadius: '12px',
        boxShadow: markInvalid ? `0 0 0 1px ${theme.general.dangerColor}` : `0 0 0 1px ${theme.Select.borderColor}`,
        caretColor: theme.general.primaryColor,
        color: theme.general.color,
        fontWeight: 400,
        height: '48px',
        lineHeight: '1.5rem',
        outline: 'none',
        padding: '0 16px',
        width: '100%',
    };
};
exports.inputStyle = inputStyle;
exports.INPUT_CLASSNAME = 'wireinput';
exports.INPUT_GROUP = 'input-group';
const filterInputProps = (props) => (0, util_1.filterProps)(props, ['markInvalid', 'placeholderTextTransform']);
const centerInputAction = {
    position: 'absolute',
    right: '16px',
    top: '50%',
    transform: 'translateY(-50%)',
};
exports.Input = React.forwardRef((_a, ref) => {
    var { type, label, error, helperText, startContent = null, endContent = null, inputCSS = {}, wrapperCSS = {}, className = '' } = _a, props = __rest(_a, ["type", "label", "error", "helperText", "startContent", "endContent", "inputCSS", "wrapperCSS", "className"]);
    const [togglePassword, setTogglePassword] = (0, react_1.useState)(false);
    const hasError = !!error;
    const isPasswordInput = type === 'password';
    const toggledPasswordType = togglePassword ? 'text' : 'password';
    const toggleSetPassword = () => setTogglePassword(prevState => !prevState);
    return ((0, jsx_runtime_1.jsxs)("div", { className: exports.INPUT_GROUP, css: (theme) => (Object.assign({ marginBottom: hasError ? '2px' : '20px', width: '100%', '&:focus-within label': {
                color: theme.general.primaryColor,
            } }, wrapperCSS)), children: [label && ((0, jsx_runtime_1.jsx)(InputLabel_1.InputLabel, { htmlFor: props.id, isRequired: props.required, markInvalid: props.markInvalid, children: label })), (0, jsx_runtime_1.jsxs)("div", { css: { marginBottom: hasError && '8px', position: 'relative' }, children: [startContent, (0, jsx_runtime_1.jsx)("input", Object.assign({ className: exports.INPUT_CLASSNAME, css: (theme) => (Object.assign(Object.assign({}, (0, exports.inputStyle)(theme, props, hasError)), inputCSS)), ref: ref, type: isPasswordInput ? toggledPasswordType : type, "aria-required": props.required }, filterInputProps(props))), endContent, hasError && !isPasswordInput && ((0, jsx_runtime_1.jsx)(Icon_1.ErrorIcon, { css: centerInputAction, width: 16, height: 16, "aria-hidden": "true" })), isPasswordInput && ((0, jsx_runtime_1.jsx)("button", { type: "button", "data-uie-name": !togglePassword ? 'do-show-password' : 'do-hide-password', css: Object.assign(Object.assign({}, centerInputAction), { background: 'transparent', border: 'none', cursor: 'pointer', padding: 0 }), onClick: toggleSetPassword, title: "Toggle password visibility", "aria-controls": props.id, "aria-expanded": togglePassword, children: togglePassword ? (0, jsx_runtime_1.jsx)(Icon_1.HideIcon, {}) : (0, jsx_runtime_1.jsx)(Icon_1.ShowIcon, {}) }))] }), !hasError && helperText && ((0, jsx_runtime_1.jsx)("p", { css: (theme) => ({
                    fontSize: theme.fontSizes.small,
                    fontWeight: 400,
                    color: theme.Input.placeholderColor,
                    marginTop: 8,
                }), children: helperText })), error] }));
});
exports.Input.displayName = 'Input';
