"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Select = void 0;
const jsx_runtime_1 = require("@emotion/react/jsx-runtime");
const react_1 = require("@emotion/react");
const react_select_1 = __importDefault(require("react-select"));
const InputLabel_1 = require("./InputLabel");
const SelectComponents_1 = require("./SelectComponents");
const SelectStyles_1 = require("./SelectStyles");
const enums_1 = require("../types/enums");
const Select = (_a) => {
    var { id, label, error, helperText, disabled = false, dataUieName, options, isMulti, wrapperCSS = {}, markInvalid = false, required = false } = _a, props = __rest(_a, ["id", "label", "error", "helperText", "disabled", "dataUieName", "options", "isMulti", "wrapperCSS", "markInvalid", "required"]);
    const theme = (0, react_1.useTheme)();
    const hasError = !!error;
    return ((0, jsx_runtime_1.jsxs)("div", { 
        // eslint-disable-next-line jsx-a11y/no-autofocus
        autoFocus: (0, SelectComponents_1.isGroup)(options), css: (theme) => (Object.assign({ marginBottom: markInvalid ? '2px' : '20px', width: '100%', '&:focus-within label': {
                color: theme.general.primaryColor,
            } }, wrapperCSS)), "data-uie-name": dataUieName, children: [label && ((0, jsx_runtime_1.jsx)(InputLabel_1.InputLabel, { htmlFor: id, markInvalid: markInvalid, isRequired: required, children: label })), (0, jsx_runtime_1.jsx)(react_select_1.default, Object.assign({ id: id, styles: (0, SelectStyles_1.customStyles)(theme, markInvalid), components: {
                    SelectContainer: SelectComponents_1.SelectContainer,
                    DropdownIndicator: SelectComponents_1.DropdownIndicator,
                    Option: (0, SelectComponents_1.CustomOption)(dataUieName),
                    Menu: (0, SelectComponents_1.Menu)(dataUieName),
                    ValueContainer: SelectComponents_1.ValueContainer,
                    IndicatorsContainer: SelectComponents_1.IndicatorsContainer,
                }, tabIndex: enums_1.TabIndex.UNFOCUSABLE, isDisabled: disabled, hideSelectedOptions: false, isSearchable: false, isClearable: false, closeMenuOnSelect: !isMulti, isMulti: isMulti, options: options }, props)), !hasError && helperText && ((0, jsx_runtime_1.jsx)("p", { css: (theme) => ({
                    fontSize: theme.fontSizes.small,
                    fontWeight: 400,
                    color: theme.Input.labelColor,
                    marginTop: 8,
                }), children: helperText })), error] }));
};
exports.Select = Select;
