"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.IndicatorsContainer = exports.ValueContainer = exports.renderValue = exports.Menu = exports.CustomOption = exports.DropdownIndicator = exports.isGroup = exports.SelectContainer = void 0;
const jsx_runtime_1 = require("@emotion/react/jsx-runtime");
/*
 * Wire
 * Copyright (C) 2022 Wire Swiss GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses/.
 *
 */
const react_select_1 = require("react-select");
const Icon_1 = require("../Icon");
const ArrowDown_1 = require("../Icon/ArrowDown");
const enums_1 = require("../types/enums");
// SelectContainer
const SelectContainer = (props) => {
    return ((0, jsx_runtime_1.jsx)(react_select_1.components.SelectContainer, Object.assign({}, props, { children: (0, jsx_runtime_1.jsx)("div", { tabIndex: enums_1.TabIndex.FOCUSABLE, children: props.children }) })));
};
exports.SelectContainer = SelectContainer;
const isGroup = (options) => {
    return options.length > 0 && 'options' in options[0];
};
exports.isGroup = isGroup;
const DropdownIndicator = (props) => {
    const { menuIsOpen } = props.selectProps;
    return ((0, jsx_runtime_1.jsx)(react_select_1.components.DropdownIndicator, Object.assign({}, props, { children: (0, jsx_runtime_1.jsx)(ArrowDown_1.ArrowDown, { css: Object.assign({}, (menuIsOpen ? { transform: 'rotateX(180deg)', marginTop: 2 } : { marginTop: 4 })) }) })));
};
exports.DropdownIndicator = DropdownIndicator;
// eslint-disable-next-line react/display-name
const CustomOption = (dataUieName) => (props) => {
    var _a;
    const { children, data, isMulti, isSelected, options } = props;
    return ((0, jsx_runtime_1.jsx)(react_select_1.components.Option, Object.assign({}, props, { children: (0, jsx_runtime_1.jsxs)("div", Object.assign({ css: Object.assign({}, ((isMulti || exports.isGroup) && {
                display: 'grid',
                gridTemplateAreas: `"checkbox label"
                                ". description"`,
                gridTemplateColumns: '22px 1fr',
                columnGap: exports.isGroup ? '5px' : '10px',
            })) }, (dataUieName && {
            'data-uie-name': `option-${dataUieName}`,
            'data-uie-value': (_a = options.find(option => option.label === children)) === null || _a === void 0 ? void 0 : _a.value,
            'data-uie-selected': isSelected,
        }), { children: [isMulti && ((0, jsx_runtime_1.jsx)("input", { type: "checkbox", checked: isSelected, onChange: () => null, css: { gridArea: 'checkbox', width: 22, height: 22, cursor: 'pointer', placeSelf: 'center' } })), (0, exports.isGroup)(options) && (
                //includes a checkmark character if it is selected and a group
                (0, jsx_runtime_1.jsx)("div", { css: { width: 22, height: 22, cursor: 'pointer', placeSelf: 'center' }, children: isSelected ? (0, jsx_runtime_1.jsx)(Icon_1.CheckIcon, {}) : null })), (0, jsx_runtime_1.jsx)("div", { css: { gridArea: 'label', overflowWrap: 'break-word', overflow: 'hidden' }, children: children }), data && data.description && ((0, jsx_runtime_1.jsx)("p", { css: (theme) => ({
                        marginBottom: 0,
                        fontSize: theme.fontSizes.medium,
                        color: isSelected ? theme.Select.focusedDescriptionColor : theme.Input.labelColor,
                        gridArea: 'description',
                    }), children: data.description }))] })) })));
};
exports.CustomOption = CustomOption;
// eslint-disable-next-line react/display-name
const Menu = (dataUieName) => (props) => {
    const { children } = props;
    return ((0, jsx_runtime_1.jsx)(react_select_1.components.Menu, Object.assign({}, props, { children: (0, jsx_runtime_1.jsx)("div", Object.assign({}, (dataUieName && {
            'data-uie-name': `dropdown-${dataUieName}`,
        }), { children: children })) })));
};
exports.Menu = Menu;
const renderValue = value => {
    if (Array.isArray(value)) {
        const currentValue = (i) => value[i].props.children;
        return ((0, jsx_runtime_1.jsx)("div", { css: {
                whiteSpace: 'nowrap',
                overflow: 'hidden',
                textOverflow: 'ellipsis',
                minWidth: 0,
                paddingRight: 14,
                gridArea: '1/1/2/3',
            }, children: currentValue(0) }));
    }
    return value;
};
exports.renderValue = renderValue;
const ValueContainer = (_a) => {
    var { children } = _a, restProps = __rest(_a, ["children"]);
    return ((0, jsx_runtime_1.jsxs)(react_select_1.components.ValueContainer, Object.assign({}, restProps, { children: [(0, exports.renderValue)(children[0]), " ", children[1]] })));
};
exports.ValueContainer = ValueContainer;
const IndicatorsContainer = (_a) => {
    var { children } = _a, restProps = __rest(_a, ["children"]);
    const value = restProps.getValue();
    const displaySelectedOptionsCount = Array.isArray(value) && value.length > 1;
    return ((0, jsx_runtime_1.jsxs)(react_select_1.components.IndicatorsContainer, Object.assign({}, restProps, { children: [displaySelectedOptionsCount && (0, jsx_runtime_1.jsxs)("div", { css: { fontWeight: 600 }, children: ["(+", value.length - 1, ")"] }), children] })));
};
exports.IndicatorsContainer = IndicatorsContainer;
