"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Switch = void 0;
const jsx_runtime_1 = require("@emotion/react/jsx-runtime");
/*
 * Wire
 * Copyright (C) 2020 Wire Swiss GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses/.
 *
 */
const react_1 = require("react");
const Identity_1 = require("../Identity");
const Misc_1 = require("../Misc");
const Switch = ({ id = Math.random().toString(), checked, onToggle = () => { }, showLoading, disabled, loadingColor = Identity_1.COLOR.BLUE, activatedColor = Identity_1.COLOR.BLUE, deactivatedColor = '#d2d2d2', name, dataUieName, }) => ((0, jsx_runtime_1.jsx)("div", { css: {
        display: 'inline-block',
        position: 'relative',
        textAlign: 'left',
        userSelect: 'none',
        verticalAlign: 'middle',
        width: '42px',
    }, children: (0, jsx_runtime_1.jsxs)(react_1.Fragment, { children: [(0, jsx_runtime_1.jsx)("input", { id: id, checked: checked, disabled: disabled, name: name, onChange: event => onToggle(event.target.checked), type: "checkbox", css: { display: 'none' }, "data-uie-name": dataUieName }), (0, jsx_runtime_1.jsxs)("label", { htmlFor: id, css: {
                    borderRadius: '20px',
                    cursor: disabled || showLoading ? '' : 'pointer',
                    display: 'block',
                    margin: 0,
                    overflow: 'hidden',
                }, children: [(0, jsx_runtime_1.jsx)("span", { css: {
                            ['&:after']: {
                                content: '" "',
                                paddingRight: '10px',
                                textAlign: 'right',
                            },
                            ['&:before']: {
                                content: '" "',
                                paddingLeft: '10px',
                            },
                            ['&:before, &:after']: {
                                backgroundColor: disabled || showLoading
                                    ? Identity_1.COLOR.tint(checked ? activatedColor : deactivatedColor, 0.4)
                                    : checked
                                        ? activatedColor
                                        : deactivatedColor,
                                boxSizing: 'border-box',
                                display: 'block',
                                float: 'left',
                                height: '25px',
                                lineHeight: '1.5625rem',
                                padding: 0,
                                width: '50%',
                            },
                            display: 'block',
                            marginLeft: checked ? 0 : '-100%',
                            transition: 'margin 0.1s ease-in 0s',
                            width: '200%',
                        } }), showLoading ? ((0, jsx_runtime_1.jsx)(Misc_1.Loading, { size: 21, color: loadingColor, style: {
                            display: 'block',
                            margin: '2px',
                            position: 'absolute',
                        } })) : ((0, jsx_runtime_1.jsx)("span", { css: {
                            background: Identity_1.COLOR.WHITE,
                            borderRadius: '100%',
                            bottom: 0,
                            boxShadow: '0px 0px 2px -1px gray',
                            display: 'block',
                            height: '23px',
                            margin: '1px',
                            opacity: disabled ? 0.7 : undefined,
                            position: 'absolute',
                            right: checked ? '0px' : '17px',
                            top: 0,
                            transition: 'all 0.15s ease-in 0s',
                            width: '23px',
                        } }))] })] }) }));
exports.Switch = Switch;
