"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Tooltip = void 0;
const jsx_runtime_1 = require("@emotion/react/jsx-runtime");
/*
 * Wire
 * Copyright (C) 2022 Wire Swiss GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses/.
 *
 */
const react_1 = require("react");
const react_dom_1 = require("react-dom");
const util_1 = require("../util");
const paddingDistance = 8;
const tooltipStyle = theme => ({
    position: 'fixed',
    zIndex: '99999',
    maxWidth: '300px',
    filter: 'drop-shadow(1px 2px 6px rgba(0, 0, 0, 0.3))',
    borderRadius: '4px',
    "&[data-position='top']": {
        paddingBottom: `${paddingDistance}px`,
        '.tooltip-arrow': {
            borderTop: `10px solid ${theme.Tooltip.backgroundColor}`,
            bottom: 0,
        },
    },
    "&[data-position='bottom']": {
        paddingTop: `${paddingDistance}px`,
        '.tooltip-arrow': {
            borderBottom: `10px solid ${theme.Tooltip.backgroundColor}`,
            top: 0,
        },
    },
    '.tooltip-content': {
        color: theme.Tooltip.color,
        backgroundColor: theme.Tooltip.backgroundColor,
        borderRadius: '4px',
        fontSize: '12px',
        lineHeight: '14px',
        fontWeight: 400,
        padding: `${paddingDistance}px 8px`,
        textAlign: 'center',
    },
    '.tooltip-arrow': {
        width: 0,
        height: 0,
        borderLeft: '8px solid transparent',
        borderRight: '8px solid transparent',
        position: 'absolute',
    },
});
const PortalComponent = ({ children, bounding, selector = '#wire-app' }) => {
    const [isTouchingTop, setIsTouchingTop] = (0, react_1.useState)(false);
    const targetElement = document.querySelector(selector);
    if (!targetElement) {
        return null;
    }
    const tooltipRef = (element) => {
        if (!bounding || !element) {
            return;
        }
        const isTouchingTopEdge = bounding.y <= element.clientHeight + paddingDistance * 2;
        setIsTouchingTop(isTouchingTopEdge);
        const elementWidth = (element.scrollWidth - bounding.width) / 2;
        element.style.left = `${bounding.x - elementWidth}px`;
        if (isTouchingTopEdge) {
            element.style.top = `${bounding.y + bounding.height}px`;
        }
        else {
            element.style.top = `${bounding.y - element.clientHeight}px`;
        }
    };
    const tooltipArrowRef = (element) => {
        if (!element) {
            return;
        }
        const { parentElement } = element;
        if (!parentElement) {
            return;
        }
        const parentElementRect = parentElement.getBoundingClientRect();
        element.style.left = `${parentElementRect.width / 2 - paddingDistance}px`;
    };
    return (0, react_dom_1.createPortal)((0, jsx_runtime_1.jsxs)("div", { ref: tooltipRef, className: "tooltip", css: (theme) => tooltipStyle(theme), "data-position": isTouchingTop ? 'bottom' : 'top', children: [(0, jsx_runtime_1.jsx)("div", { ref: tooltipArrowRef, className: "tooltip-arrow" }), (0, jsx_runtime_1.jsx)("div", { className: "tooltip-content", "data-testid": "tooltip-content", children: children })] }), targetElement);
};
const filterTooltipProps = (props) => (0, util_1.filterProps)(props, ['body']);
const Tooltip = (_a) => {
    var { children } = _a, props = __rest(_a, ["children"]);
    const [isHovered, setIsHovered] = (0, react_1.useState)(false);
    const boundingRectRef = (0, react_1.useRef)();
    const filteredProps = filterTooltipProps(props);
    const { body, selector = '#wire-app' } = props;
    const onElementEnter = (event) => {
        const boundingRect = event.currentTarget.getBoundingClientRect();
        setIsHovered(true);
        boundingRectRef.current = boundingRect;
    };
    const onElementLeave = () => setIsHovered(false);
    return ((0, jsx_runtime_1.jsxs)("div", Object.assign({ role: "presentation" }, filteredProps, { "data-testid": "tooltip-wrapper", onMouseEnter: onElementEnter, onMouseLeave: onElementLeave, onFocus: onElementEnter, onBlur: onElementLeave }, props, { children: [children, isHovered && ((0, jsx_runtime_1.jsx)(PortalComponent, { bounding: boundingRectRef.current, selector: selector, children: body }))] })));
};
exports.Tooltip = Tooltip;
