"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.HeaderMenu = void 0;
const jsx_runtime_1 = require("@emotion/react/jsx-runtime");
/*
 * Wire
 * Copyright (C) 2018 Wire Swiss GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses/.
 *
 */
const react_1 = require("react");
const MenuContent_1 = require("./MenuContent");
const MenuItems_1 = require("./MenuItems");
const MenuOpenButton_1 = require("./MenuOpenButton");
const MenuScrollableItems_1 = require("./MenuScrollableItems");
const HeaderMenu = (_a) => {
    var { children, logoElement = null, centerElement = null } = _a, props = __rest(_a, ["children", "logoElement", "centerElement"]);
    const [isOpen, setIsOpen] = (0, react_1.useState)(false);
    const toggleMenu = () => {
        if (typeof window !== 'undefined') {
            window.scrollTo(0, 0);
            setIsOpen(current => !current);
        }
    };
    const closeMenu = () => setIsOpen(false);
    return ((0, jsx_runtime_1.jsx)("div", Object.assign({ css: { height: '64px' } }, props, { "data-uie-name": "element-header-menu", children: (0, jsx_runtime_1.jsxs)(MenuContent_1.MenuContent, { open: isOpen, children: [(0, jsx_runtime_1.jsx)("div", { css: { alignSelf: 'center', display: 'flex', zIndex: 2 }, onClick: closeMenu, children: logoElement }), (0, jsx_runtime_1.jsx)("div", { css: { alignSelf: 'center', display: 'flex' }, children: centerElement }), (0, jsx_runtime_1.jsx)(MenuOpenButton_1.MenuOpenButton, { onClick: toggleMenu, open: isOpen, style: { justifySelf: 'end', position: isOpen ? 'fixed' : undefined, right: '16px', top: '21px' }, "data-uie-name": "do-toggle-header-menu" }), (0, jsx_runtime_1.jsx)(MenuItems_1.MenuItems, { onClick: closeMenu, open: isOpen, children: (0, jsx_runtime_1.jsx)(MenuScrollableItems_1.MenuScrollableItems, { children: children }) })] }) })));
};
exports.HeaderMenu = HeaderMenu;
