"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.HeaderSubMenu = exports.MobileStyledHeaderSubMenu = exports.DesktopStyledHeaderSubMenu = exports.DESKTOP_HEADER_SUB_MENU_CLASSNAME = void 0;
const jsx_runtime_1 = require("@emotion/react/jsx-runtime");
const MenuLink_1 = require("./MenuLink");
const MenuSubLink_1 = require("./MenuSubLink");
const Identity_1 = require("../../Identity");
const motions_1 = require("../../Identity/motions");
const mediaQueries_1 = require("../../mediaQueries");
const desktopStyledHeaderSubMenuStyle = theme => ({
    alignItems: 'left',
    backgroundColor: Identity_1.COLOR.tint(theme.general.backgroundColor, 0.16),
    borderRadius: '8px',
    boxShadow: '0 8px 24px 0 rgba(0, 0, 0, 0.16)',
    display: 'flex',
    flexDirection: 'column',
    justifyContent: 'center',
    minWidth: '200px',
    padding: '8px 8px',
    span: {
        '&:hover': {
            backgroundColor: theme.general.backgroundColor,
            borderRadius: '4px',
        },
        alignItems: 'center',
        display: 'flex',
        height: '30px',
        margin: 0,
        paddingLeft: '10px !important',
        paddingRight: '10px !important',
        whiteSpace: 'nowrap',
    },
    [`.${MenuLink_1.MENU_LINK_CLASSNAME}:nth-of-type(n+2)`]: {
        marginTop: '8px',
    },
});
exports.DESKTOP_HEADER_SUB_MENU_CLASSNAME = 'desktopStyledHeaderSubMenu';
const DesktopStyledHeaderSubMenu = (props) => ((0, jsx_runtime_1.jsx)("div", Object.assign({ className: exports.DESKTOP_HEADER_SUB_MENU_CLASSNAME, css: (theme) => desktopStyledHeaderSubMenuStyle(theme, props) }, props)));
exports.DesktopStyledHeaderSubMenu = DesktopStyledHeaderSubMenu;
const mobileStyledHeaderSubMenuStyle = _ => ({
    '*': {
        fontWeight: 200,
    },
    alignItems: 'center',
    borderTop: `1px solid ${Identity_1.COLOR.GRAY_LIGHTEN_72}`,
    display: 'flex',
    flexDirection: 'column',
    justifyContent: 'center',
    marginTop: '16px',
    paddingTop: '8px',
});
const MobileStyledHeaderSubMenu = (props) => ((0, jsx_runtime_1.jsx)("span", Object.assign({ css: mobileStyledHeaderSubMenuStyle(props) }, props)));
exports.MobileStyledHeaderSubMenu = MobileStyledHeaderSubMenu;
const HeaderSubMenu = (_a) => {
    var { caption, isOpen, children } = _a, props = __rest(_a, ["caption", "isOpen", "children"]);
    const isDesktop = typeof window !== 'undefined' && window.matchMedia(`(${mediaQueries_1.QUERY.desktop})`).matches;
    return ((0, jsx_runtime_1.jsxs)(MenuSubLink_1.MenuSubLink, Object.assign({}, props, { style: { cursor: 'pointer', display: 'inline-block', position: 'relative', textAlign: 'center' }, children: [(0, jsx_runtime_1.jsx)("span", { children: caption }), (0, jsx_runtime_1.jsx)(Identity_1.Opacity, { in: isOpen && isDesktop, timeout: motions_1.DURATION.DEFAULT, style: { display: 'inline-block', left: -18, marginTop: 10, paddingTop: 20, position: 'absolute', zIndex: 1 }, mountOnEnter: false, unmountOnExit: false, children: (0, jsx_runtime_1.jsx)(Identity_1.YAxisMovement, { in: isOpen && isDesktop, startValue: '-30px', endValue: '0px', style: { display: 'inline-block' }, timeout: motions_1.DURATION.DEFAULT, mountOnEnter: false, unmountOnExit: true, children: (0, jsx_runtime_1.jsx)(exports.DesktopStyledHeaderSubMenu, { children: children }) }) }), (0, jsx_runtime_1.jsx)(Identity_1.Opacity, { in: isOpen && !isDesktop, timeout: motions_1.DURATION.DEFAULT, mountOnEnter: false, unmountOnExit: false, style: { display: 'block', position: 'relative' }, children: (0, jsx_runtime_1.jsx)(Identity_1.Slide, { in: isOpen && !isDesktop, startValue: '-56%', endValue: '0', timeout: motions_1.DURATION.DEFAULT, mountOnEnter: false, unmountOnExit: true, children: (0, jsx_runtime_1.jsx)(exports.MobileStyledHeaderSubMenu, { children: children }) }) })] })));
};
exports.HeaderSubMenu = HeaderSubMenu;
