"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.IconButton = exports.iconButtonStyle = exports.IconButtonVariant = void 0;
const jsx_runtime_1 = require("@emotion/react/jsx-runtime");
const motions_1 = require("../Identity/motions");
const Text_1 = require("../Text");
const util_1 = require("../util");
var IconButtonVariant;
(function (IconButtonVariant) {
    IconButtonVariant["PRIMARY"] = "primary";
    IconButtonVariant["SECONDARY"] = "secondary";
})(IconButtonVariant || (exports.IconButtonVariant = IconButtonVariant = {}));
const iconButtonStyle = (theme, { variant = IconButtonVariant.PRIMARY, backgroundColor, disabled = false }) => (Object.assign(Object.assign({ border: 0, borderRadius: '12px', cursor: disabled ? 'default' : 'pointer', display: 'flex', alignItems: 'center', justifyContent: 'center', marginBottom: '16px', padding: 0, outline: 'none', textDecoration: 'none', touchAction: 'manipulation', transition: motions_1.defaultTransition, width: '40px', height: '32px', '&:hover, &:focus': {
        textDecoration: 'none',
    } }, (variant === IconButtonVariant.PRIMARY && Object.assign({ backgroundColor: disabled
        ? theme.IconButton.primaryDisabledBgColor
        : backgroundColor || theme.IconButton.primaryBgColor, border: disabled
        ? `1px solid ${theme.IconButton.primaryDisabledBorderColor}`
        : `1px solid ${theme.IconButton.primaryBorderColor}`, svg: {
        fill: disabled ? theme.Input.placeholderColor : theme.general.color,
    } }, (!disabled && {
    '&:hover, &:focus': {
        backgroundColor: theme.IconButton.hoverPrimaryBgColor,
    },
    '&:hover': {
        borderColor: theme.IconButton.primaryHoverBorderColor,
    },
    '&:focus': {
        borderColor: theme.IconButton.focusBorderColor,
    },
    '&:active': {
        backgroundColor: theme.IconButton.activePrimaryBgColor,
        borderColor: theme.IconButton.focusBorderColor,
        svg: {
            fill: theme.general.primaryColor,
        },
    },
})))), (variant === IconButtonVariant.SECONDARY && Object.assign({ backgroundColor: 'inherit', svg: {
        fill: disabled ? theme.Input.placeholderColor : theme.general.color,
    } }, (!disabled && {
    '&:hover, &:focus, &:active': {
        svg: {
            fill: theme.general.primaryColor,
        },
    },
    '&:focus': {
        border: `1px solid ${theme.IconButton.focusBorderColor}`,
    },
    '&:active': {
        border: `1px solid ${theme.IconButton.secondaryActiveBorderColor}`,
        backgroundColor: theme.Input.backgroundColor,
    },
})))));
exports.iconButtonStyle = iconButtonStyle;
const IconButton = (_a) => {
    var { children } = _a, props = __rest(_a, ["children"]);
    return ((0, jsx_runtime_1.jsx)("button", Object.assign({ css: (theme) => (0, exports.iconButtonStyle)(theme, props) }, filterButtonProps(props), { children: children })));
};
exports.IconButton = IconButton;
const filterButtonProps = (props) => {
    return (0, util_1.filterProps)((0, Text_1.filterTextProps)(props), ['backgroundColor']);
};
